/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax;

import com.scriptbasic.exceptions.GenericSyntaxException;
import com.scriptbasic.exceptions.LexicalException;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.Factory;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.interfaces.NestedStructure;
import com.scriptbasic.interfaces.NestedStructureHouseKeeper;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import java.util.Stack;

public abstract class AbstractNestedStructureHouseKeeper
implements NestedStructureHouseKeeper {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNestedStructureHouseKeeper.class);
    private Factory factory;
    private Stack<Structure> stack = new Stack();
    private boolean stackIsHealthy = true;

    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
    }

    @Override
    public void push(NestedStructure element) {
        this.push(element.getClass(), element);
    }

    protected boolean isStackIsHealthy() {
        return this.stackIsHealthy;
    }

    @Override
    public void push(Class<?> klass, NestedStructure element) {
        Structure stackFrame = new Structure();
        stackFrame.setElementType(klass);
        stackFrame.setPushedElement(element);
        this.stack.push(stackFrame);
    }

    @Override
    public <T extends NestedStructure> T pop(Class<T> expectedClass) throws AnalysisException {
        Structure stackFrame;
        Structure structure = stackFrame = this.stack.isEmpty() ? null : this.stack.peek();
        if (stackFrame == null || !expectedClass.isAssignableFrom(stackFrame.getElementType())) {
            this.stackIsHealthy = false;
            GenericSyntaxException se = new GenericSyntaxException("Bad nested structures");
            LexicalAnalyzer la = this.factory.get(LexicalAnalyzer.class);
            try {
                LexicalElement le = la.peek();
                se.setLocation(le);
            }
            catch (LexicalException e) {
                LOG.error("There was an error when trying to fetch the current source location", e);
            }
            throw se;
        }
        this.stack.pop();
        return (T)(stackFrame == null ? null : stackFrame.getPushedElement());
    }

    protected static class Structure {
        private Class<?> elementType;
        private NestedStructure pushedElement;

        protected Structure() {
        }

        public Class<?> getElementType() {
            return this.elementType;
        }

        public void setElementType(Class<?> elementType) {
            this.elementType = elementType;
        }

        public NestedStructure getPushedElement() {
            return this.pushedElement;
        }

        public void setPushedElement(NestedStructure pushedElement) {
            this.pushedElement = pushedElement;
        }
    }
}

