/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.memory;

import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.memory.BasicVariableMap;
import java.util.HashMap;
import java.util.Map;

class BasicVariableRegistry
extends BasicVariableMap {
    private final Map<String, VariableType> registrationMap = new HashMap<String, VariableType>();
    private BasicVariableMap that;

    BasicVariableRegistry(BasicVariableMap that) {
        super(that);
        this.that = that;
    }

    private void assertNoOverregistration(String variableName, VariableType type) throws ExecutionException {
        this.that.assertCorrectCasing(variableName);
        String convertedVariableName = this.converted(variableName);
        if (this.registrationMap.containsKey(convertedVariableName) && this.registrationMap.get(convertedVariableName) != type) {
            throw new BasicRuntimeException("Variable '" + variableName + "' can not be local and global at a time.");
        }
    }

    void registerLocal(String variableName) throws ExecutionException {
        this.assertNoOverregistration(variableName, VariableType.KNOWN_LOCAL);
        String convertedVariableName = this.converted(variableName);
        this.that.registerVariableCasing(variableName);
        this.registrationMap.put(convertedVariableName, VariableType.KNOWN_LOCAL);
    }

    void registerGlobal(String variableName) throws ExecutionException {
        this.assertNoOverregistration(variableName, VariableType.KNOWN_GLOBAL);
        String convertedVariableName = this.converted(variableName);
        this.that.registerVariableCasing(variableName);
        this.registrationMap.put(convertedVariableName, VariableType.KNOWN_GLOBAL);
    }

    boolean isGlobal(String variableName) throws ExecutionException {
        this.that.assertCorrectCasing(variableName);
        String convertedVariableName = this.converted(variableName);
        return this.registrationMap.get(convertedVariableName) == VariableType.KNOWN_GLOBAL;
    }

    boolean isLocal(String variableName) throws ExecutionException {
        this.that.assertCorrectCasing(variableName);
        String convertedVariableName = this.converted(variableName);
        return this.registrationMap.get(convertedVariableName) == VariableType.KNOWN_LOCAL;
    }

    private static enum VariableType {
        KNOWN_LOCAL,
        KNOWN_GLOBAL;

    }
}

