/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.configuration;

import com.scriptbasic.api.Configuration;
import com.scriptbasic.errors.BasicInterpreterInternalError;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class BasicConfiguration
implements Configuration {
    private static final Logger LOG = LoggerFactory.getLogger();
    private final Map<String, List<String>> lists = new HashMap<String, List<String>>();
    private Properties configProperties;

    public BasicConfiguration() {
        try {
            this.loadDefaultConfiguration();
        }
        catch (Exception e) {
            LOG.error("Configuration was not loaded", e);
        }
    }

    @Override
    public Properties getConfigProperties() {
        return this.configProperties;
    }

    @Override
    public void setConfigProperties(Properties configProperties) {
        this.configProperties = configProperties;
        this.lists.clear();
    }

    @Override
    public Optional<String> getConfigValue(String key) {
        String sysValue;
        String configValue = null;
        String envKey = "sb4j." + key;
        if (this.configProperties != null && this.configProperties.containsKey(key)) {
            configValue = this.configProperties.getProperty(key);
        }
        if ((sysValue = System.getenv(envKey)) != null) {
            configValue = sysValue;
        }
        if ((sysValue = System.getProperty(envKey)) != null) {
            configValue = sysValue;
        }
        return Optional.ofNullable(configValue);
    }

    @Override
    public List<String> getConfigValueList(String key) {
        if (this.lists.containsKey(key)) {
            return this.lists.get(key);
        }
        LinkedList<String> list = new LinkedList<String>();
        int i = 0;
        while (this.getConfigValue(key, i).isPresent()) {
            list.add(this.getConfigValue(key, i).get());
            ++i;
        }
        this.lists.put(key, list);
        return list;
    }

    @Override
    public void loadDefaultConfiguration() {
        String systemPropertyDefinedConfiguration = System.getProperty("sb4j.configuration");
        String configurationFileName = systemPropertyDefinedConfiguration == null ? "sb4j.properties" : systemPropertyDefinedConfiguration;
        LOG.info("Reading configuration from file {}", configurationFileName);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(configurationFileName);
        if (null == is) {
            LOG.info("Configuration file does not exist.", new Object[0]);
            this.setConfigProperties(new Properties());
        } else {
            this.loadConfiguration(is);
        }
    }

    @Override
    public void loadConfiguration(InputStream is) {
        Properties configProperties = new Properties();
        try {
            configProperties.load(is);
            this.setConfigProperties(configProperties);
        }
        catch (IOException e) {
            LOG.error("Can not load the configuration.", e);
            this.setConfigProperties(new Properties());
        }
    }

    @Override
    public void set(String name, String value) {
        this.configProperties.put(name, value);
    }

    @Override
    public void set(String command) {
        int index = command.indexOf("=");
        if (index == -1) {
            throw new BasicInterpreterInternalError("Configuration command '" + command + "' is invalid.");
        }
        this.configProperties.put(command.substring(0, index), command.substring(index + 1));
    }
}

