/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.executors.rightvalues;

import com.scriptbasic.api.ScriptBasicException;
import com.scriptbasic.executors.AbstractIdentifieredExpressionListedExpression;
import com.scriptbasic.executors.commands.CommandSub;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.interfaces.ExpressionList;
import com.scriptbasic.spi.Interpreter;
import com.scriptbasic.spi.RightValue;
import com.scriptbasic.utility.ExpressionUtility;
import com.scriptbasic.utility.ReflectionUtility;
import com.scriptbasic.utility.RightValueUtility;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;

public class FunctionCall
extends AbstractIdentifieredExpressionListedExpression {
    private boolean commandNeedLookup = true;
    private CommandSub commandSub = null;

    private static RightValue[] evaluateArguments(ExpressionList argumentList, Interpreter interpreter) throws ScriptBasicException {
        RightValue[] argumentValues;
        if (argumentList == null) {
            argumentValues = null;
        } else {
            Iterator expressionIterator = argumentList.iterator();
            argumentValues = new RightValue[argumentList.size()];
            for (int i = 0; i < argumentValues.length; ++i) {
                argumentValues[i] = ((Expression)expressionIterator.next()).evaluate(interpreter);
            }
        }
        return argumentValues;
    }

    private RightValue callBasicFunction(Interpreter interpreter) throws ScriptBasicException {
        return ExpressionUtility.callBasicFunction(interpreter, FunctionCall.evaluateArguments(this.getExpressionList(), interpreter), this.commandSub, this.getVariableName());
    }

    private RightValue callJavaFunction(Interpreter interpreter) throws ScriptBasicException {
        String functionName = this.getVariableName();
        List<RightValue> args = ExpressionUtility.evaluateExpressionList(interpreter, this.getExpressionList());
        Method method = interpreter.getJavaMethod(null, functionName);
        if (method == null) {
            throw new BasicRuntimeException("There is no callable function '" + functionName + "'");
        }
        Object methodResult = ReflectionUtility.invoke(interpreter, functionName, method, null, args);
        RightValue result = RightValueUtility.createRightValue(methodResult);
        return result;
    }

    private void lookUpCommandSub(Interpreter interpreter) {
        if (this.commandNeedLookup) {
            this.commandNeedLookup = false;
            this.commandSub = interpreter.getSubroutine(this.getVariableName());
        }
    }

    @Override
    public RightValue evaluate(Interpreter interpreter) throws ScriptBasicException {
        this.lookUpCommandSub(interpreter);
        RightValue result = this.commandSub == null ? this.callJavaFunction(interpreter) : this.callBasicFunction(interpreter);
        return result;
    }
}

