/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.agent.middlewares;

import com.securenative.agent.SecureNative;
import com.securenative.agent.utils.SignatureUtils;
import com.securenative.agent.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class VerifyWebhookMiddleware
implements Filter {
    private static final Logger logger = Logger.getLogger(VerifyWebhookMiddleware.class.getName());
    private SecureNative secureNative;
    private final String SIGNATURE_KEY = "x-securenative";

    public VerifyWebhookMiddleware(SecureNative secureNative) {
        this.secureNative = secureNative;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String payload;
        if (servletRequest == null) {
            return;
        }
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse res = (HttpServletResponse)servletResponse;
        String signature = "";
        if (!Utils.isNullOrEmpty(req.getHeader("x-securenative"))) {
            signature = req.getHeader("x-securenative");
        }
        if (SignatureUtils.isValidSignature(payload = this.getBody(servletRequest), signature, this.secureNative.getApiKey())) {
            filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        logger.fine("Request have been blocked due to incompatible signature");
        res.sendError(401, "Unauthorized");
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBody(ServletRequest servletRequest) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = null;){
            ServletInputStream inputStream = servletRequest.getInputStream();
            if (inputStream != null) {
                int bytesRead;
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                char[] charBuffer = new char[128];
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            }
        }
        return stringBuilder.toString();
    }
}

