/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.agent.snpackage;

import com.securenative.agent.models.Dependency;
import com.securenative.agent.snpackage.PackageItem;
import com.securenative.agent.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PackageManager {
    private static final Logger logger = Logger.getLogger(PackageManager.class.getName());

    private static Document readPackageFile(String filePath) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(new File(filePath));
            document.getDocumentElement().normalize();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.fine(String.join((CharSequence)"Could not parse pom file; ", e.toString()));
        }
        return document;
    }

    private static Dependency[] parseDependencies(NodeList nodeList) {
        Dependency[] dependencies = new Dependency[nodeList.getLength()];
        int j = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element eElement = (Element)node;
            String name = eElement.getElementsByTagName("groupId").item(0).getTextContent().concat(":").concat(eElement.getElementsByTagName("artifactId").item(0).getTextContent());
            try {
                dependencies[j] = new Dependency(name, eElement.getElementsByTagName("version").item(0).getTextContent());
            }
            catch (Exception e) {
                dependencies[j] = new Dependency(name, "LATEST");
            }
            ++j;
        }
        return dependencies;
    }

    private static String parseParent(NodeList nodeList, String key) {
        Node node = nodeList.item(0);
        if (node.getNodeType() == 1) {
            Element eElement = (Element)node;
            return eElement.getAttribute(key);
        }
        return "";
    }

    public static PackageItem getPackage(String packageFilePath) {
        String version;
        String groupId;
        String artifactId;
        Document document = PackageManager.readPackageFile(packageFilePath);
        NodeList deps = document.getElementsByTagName("dependency");
        NodeList parent = document.getElementsByTagName("parent");
        if (parent.getLength() > 0) {
            artifactId = PackageManager.parseParent(parent, "artifactId");
            groupId = PackageManager.parseParent(parent, "groupId");
            version = PackageManager.parseParent(parent, "version");
        } else {
            artifactId = document.getElementsByTagName("artifactId").item(0).getTextContent();
            groupId = document.getElementsByTagName("groupId").item(0).getTextContent();
            version = document.getElementsByTagName("version").item(0).getTextContent();
        }
        Object[] dependencies = PackageManager.parseDependencies(deps);
        String dependenciesHash = "";
        if (dependencies.length > 0) {
            dependenciesHash = Utils.calculateHash(Arrays.toString(dependencies));
        }
        String name = groupId.concat(":").concat(artifactId);
        return new PackageItem(name, version, (Dependency[])dependencies, dependenciesHash);
    }
}

