/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.models;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.securenative.Logger;
import com.securenative.SecureNative;
import com.securenative.config.SecureNativeOptions;
import com.securenative.context.SecureNativeContext;
import com.securenative.context.SecureNativeContextBuilder;
import com.securenative.models.ClientToken;
import com.securenative.models.Event;
import com.securenative.models.EventOptions;
import com.securenative.models.RequestContext;
import com.securenative.models.UserTraits;
import com.securenative.utils.DateUtils;
import com.securenative.utils.EncryptionUtils;
import java.util.Map;
import java.util.UUID;

public class SDKEvent
implements Event {
    private final String rid;
    public String eventType;
    public String userId;
    private final UserTraits userTraits;
    public RequestContext request;
    public String timestamp;
    public Map<Object, Object> properties;
    public static final Logger logger = Logger.getLogger(SecureNative.class);

    public SDKEvent(EventOptions event, SecureNativeOptions options) {
        SecureNativeContext context = event.getContext() != null ? event.getContext() : SecureNativeContextBuilder.defaultContextBuilder().build();
        ClientToken clientToken = this.decryptToken(context.getClientToken(), options.getApiKey());
        this.rid = UUID.randomUUID().toString();
        this.eventType = event.getEvent();
        this.userId = event.getUserId();
        this.userTraits = event.getUserTraits();
        this.request = new RequestContext.RequestContextBuilder().withCid(clientToken.getCid()).withVid(clientToken.getVid()).withFp(clientToken.getFp()).withIp(context.getIp()).withRemoteIp(context.getRemoteIp()).withMethod(context.getMethod()).withUrl(context.getUrl()).witHeaders(context.getHeaders()).build();
        this.timestamp = DateUtils.toTimestamp(event.getTimestamp());
        this.properties = event.getProperties();
    }

    private ClientToken decryptToken(String token, String key) {
        if (token == null || token.length() == 0) {
            return new ClientToken();
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            String decryptedClientToken = EncryptionUtils.decrypt(token, key);
            return (ClientToken)mapper.readValue(decryptedClientToken, ClientToken.class);
        }
        catch (Exception ex) {
            logger.error("Failed to decrypt token", new Object[0]);
            return new ClientToken();
        }
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    public String getRid() {
        return this.rid;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserTraits getUserTraits() {
        return this.userTraits;
    }

    public RequestContext getRequest() {
        return this.request;
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    public Map<Object, Object> getProperties() {
        return this.properties;
    }
}

