/*
 * Decompiled with CFR 0.152.
 */
package cli;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.segment.analytics.Analytics;
import com.segment.analytics.Callback;
import com.segment.analytics.messages.AliasMessage;
import com.segment.analytics.messages.GroupMessage;
import com.segment.analytics.messages.IdentifyMessage;
import com.segment.analytics.messages.Message;
import com.segment.analytics.messages.MessageBuilder;
import com.segment.analytics.messages.ScreenMessage;
import com.segment.analytics.messages.TrackMessage;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.Phaser;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.docopt.Docopt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\u001a\u0019\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\n\u001a\u0018\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\u0003\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"GSON", "Lcom/google/gson/Gson;", "usage", "", "getUsage", "()Ljava/lang/String;", "main", "", "rawArgs", "", "([Ljava/lang/String;)V", "parseJson", "", "k", "analytics-cli"})
public final class MainKt {
    @NotNull
    private static final String usage = "\nAnalytics Java CLI\n\nUsage:\n  analytics --writeKey=<writeKey> --type=<type> --userId=<userId> [--event=<event>] [--properties=<properties>] [--name=<name>] [--traits=<traits>] [--groupId=<groupId>] [--previousId=<previousId>]\n\n  analytics -h | --help\n  analytics --version\n\nOptions:\n  -h --help     Show this screen.\n  --version     Show version.\n";
    private static final Gson GSON;

    @NotNull
    public static final String getUsage() {
        return usage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(@NotNull String[] rawArgs) {
        Object traits;
        Object properties;
        MessageBuilder messageBuilder;
        Object eventType;
        Intrinsics.checkParameterIsNotNull((Object)rawArgs, (String)"rawArgs");
        Map args = new Docopt(usage).parse(ArraysKt.toList((Object[])rawArgs));
        Object v = eventType = args.get("--type");
        if (Intrinsics.areEqual(v, (Object)"track")) {
            Object v2 = args.get("--event");
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            TrackMessage.Builder builder = TrackMessage.builder((String)((String)v2));
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"TrackMessage.builder(args[\"--event\"] as String)");
            messageBuilder = (MessageBuilder)builder;
            properties = args.get("--properties");
            if (properties != null) {
                Object v3 = properties;
                if (v3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                ((TrackMessage.Builder)messageBuilder).properties(MainKt.parseJson((String)v3));
            }
        } else if (Intrinsics.areEqual(v, (Object)"page") || Intrinsics.areEqual(v, (Object)"screen")) {
            Object v4 = args.get("--name");
            if (v4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            ScreenMessage.Builder builder = ScreenMessage.builder((String)((String)v4));
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"ScreenMessage.builder(args[\"--name\"] as String)");
            messageBuilder = (MessageBuilder)builder;
            properties = args.get("--properties");
            if (properties != null) {
                Object v5 = properties;
                if (v5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                ((ScreenMessage.Builder)messageBuilder).properties(MainKt.parseJson((String)v5));
            }
        } else if (Intrinsics.areEqual(v, (Object)"identify")) {
            IdentifyMessage.Builder builder = IdentifyMessage.builder();
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"IdentifyMessage.builder()");
            messageBuilder = (MessageBuilder)builder;
            traits = args.get("--traits");
            if (traits != null) {
                Object v6 = traits;
                if (v6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                ((IdentifyMessage.Builder)messageBuilder).traits(MainKt.parseJson((String)v6));
            }
        } else if (Intrinsics.areEqual(v, (Object)"alias")) {
            Object v7 = args.get("--previousId");
            if (v7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            AliasMessage.Builder builder = AliasMessage.builder((String)((String)v7));
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"AliasMessage.builder(arg\u2026--previousId\"] as String)");
            messageBuilder = (MessageBuilder)builder;
        } else if (Intrinsics.areEqual(v, (Object)"group")) {
            Object v8 = args.get("--groupId");
            if (v8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            GroupMessage.Builder builder = GroupMessage.builder((String)((String)v8));
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"GroupMessage.builder(args[\"--groupId\"] as String)");
            messageBuilder = (MessageBuilder)builder;
            traits = args.get("--traits");
            if (traits != null) {
                Object v9 = traits;
                if (v9 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                ((GroupMessage.Builder)messageBuilder).traits(MainKt.parseJson((String)v9));
            }
        } else {
            throw (Throwable)((Object)new AssertionError((Object)"unknown command"));
        }
        Object userId = args.get("--userId");
        if (userId != null) {
            Object v10 = userId;
            if (v10 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            messageBuilder.userId((String)v10);
        }
        Object v11 = args.get("--writeKey");
        if (v11 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String writeKey = (String)v11;
        Phaser phaser = new Phaser(1);
        Analytics analytics2 = Analytics.builder((String)writeKey).flushQueueSize(1).callback(new Callback(phaser){
            final /* synthetic */ Phaser $phaser;

            public void success(@Nullable Message message) {
                this.$phaser.arrive();
            }

            public void failure(@Nullable Message message, @Nullable Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 == null) {
                    Intrinsics.throwNpe();
                }
                throw throwable2;
            }
            {
                this.$phaser = $captured_local_variable$0;
            }
        }).build();
        try {
            phaser.register();
            analytics2.enqueue(messageBuilder);
            phaser.arriveAndAwaitAdvance();
        }
        finally {
            analytics2.shutdown();
        }
    }

    @NotNull
    public static final Map<String, ?> parseJson(@NotNull String k) {
        Intrinsics.checkParameterIsNotNull((Object)k, (String)"k");
        Type collectionType2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
        Map map = (Map)GSON.fromJson(k, collectionType2);
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"GSON.fromJson(k, collectionType)");
        return map;
    }

    static {
        usage = usage;
        GSON = new Gson();
    }
}

