/*
 * Decompiled with CFR 0.152.
 */
package cli;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.segment.analytics.Analytics;
import com.segment.analytics.Callback;
import com.segment.analytics.messages.AliasMessage;
import com.segment.analytics.messages.GroupMessage;
import com.segment.analytics.messages.IdentifyMessage;
import com.segment.analytics.messages.Message;
import com.segment.analytics.messages.MessageBuilder;
import com.segment.analytics.messages.PageMessage;
import com.segment.analytics.messages.ScreenMessage;
import com.segment.analytics.messages.TrackMessage;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.Phaser;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.docopt.Docopt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\u001a\u0019\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\n\u001a\u0018\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\u0003\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"GSON", "Lcom/google/gson/Gson;", "usage", "", "getUsage", "()Ljava/lang/String;", "main", "", "rawArgs", "", "([Ljava/lang/String;)V", "parseJson", "", "k", "analytics-cli"})
public final class MainKt {
    @NotNull
    private static final String usage = "\nAnalytics Java CLI\n\nUsage:\n  analytics --writeKey=<writeKey> --type=<type> --userId=<userId> [--event=<event>] [--properties=<properties>] [--name=<name>] [--traits=<traits>] [--groupId=<groupId>] [--previousId=<previousId>] [--anonymousId=<anonymousId>] [--integrations=<integrations>] [--context=<context>]\n\n\n  analytics -h | --help\n  analytics --version\n\nOptions:\n  -h --help     Show this screen.\n  --version     Show version.\n";
    @NotNull
    private static final Gson GSON = new Gson();

    @NotNull
    public static final String getUsage() {
        return usage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(@NotNull String[] rawArgs) {
        Object context;
        Object integrations;
        Object anonymousId;
        Object userId;
        Object traits;
        Object properties;
        Object eventType;
        Intrinsics.checkNotNullParameter((Object)rawArgs, (String)"rawArgs");
        Map args = new Docopt(usage).parse(ArraysKt.toList((Object[])rawArgs));
        MessageBuilder messageBuilder = null;
        Object v = eventType = args.get("--type");
        if (Intrinsics.areEqual(v, (Object)"track")) {
            Object v2 = args.get("--event");
            Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.String");
            TrackMessage.Builder builder = TrackMessage.builder((String)((String)v2));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
            messageBuilder = (MessageBuilder)builder;
            properties = args.get("--properties");
            if (properties != null) {
                ((TrackMessage.Builder)messageBuilder).properties(MainKt.parseJson((String)properties));
            }
        } else if (Intrinsics.areEqual(v, (Object)"page")) {
            Object v3 = args.get("--name");
            Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type kotlin.String");
            PageMessage.Builder builder = PageMessage.builder((String)((String)v3));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
            messageBuilder = (MessageBuilder)builder;
            properties = args.get("--properties");
            if (properties != null) {
                ((PageMessage.Builder)messageBuilder).properties(MainKt.parseJson((String)properties));
            }
        } else if (Intrinsics.areEqual(v, (Object)"screen")) {
            Object v4 = args.get("--name");
            Intrinsics.checkNotNull(v4, (String)"null cannot be cast to non-null type kotlin.String");
            ScreenMessage.Builder builder = ScreenMessage.builder((String)((String)v4));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
            messageBuilder = (MessageBuilder)builder;
            properties = args.get("--properties");
            if (properties != null) {
                ((ScreenMessage.Builder)messageBuilder).properties(MainKt.parseJson((String)properties));
            }
        } else if (Intrinsics.areEqual(v, (Object)"identify")) {
            IdentifyMessage.Builder builder = IdentifyMessage.builder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
            messageBuilder = (MessageBuilder)builder;
            traits = args.get("--traits");
            if (traits != null) {
                ((IdentifyMessage.Builder)messageBuilder).traits(MainKt.parseJson((String)traits));
            }
        } else if (Intrinsics.areEqual(v, (Object)"alias")) {
            Object v5 = args.get("--previousId");
            Intrinsics.checkNotNull(v5, (String)"null cannot be cast to non-null type kotlin.String");
            AliasMessage.Builder builder = AliasMessage.builder((String)((String)v5));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
            messageBuilder = (MessageBuilder)builder;
        } else if (Intrinsics.areEqual(v, (Object)"group")) {
            Object v6 = args.get("--groupId");
            Intrinsics.checkNotNull(v6, (String)"null cannot be cast to non-null type kotlin.String");
            GroupMessage.Builder builder = GroupMessage.builder((String)((String)v6));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
            messageBuilder = (MessageBuilder)builder;
            traits = args.get("--traits");
            if (traits != null) {
                ((GroupMessage.Builder)messageBuilder).traits(MainKt.parseJson((String)traits));
            }
        } else {
            throw new AssertionError((Object)"unknown command");
        }
        if ((userId = args.get("--userId")) != null) {
            messageBuilder.userId((String)userId);
        }
        if ((anonymousId = args.get("--anonymousId")) != null) {
            messageBuilder.anonymousId((String)anonymousId);
        }
        if ((integrations = args.get("--integrations")) != null) {
            Map<String, ?> integrationsMap = MainKt.parseJson((String)integrations);
            for (Map.Entry<String, ?> object : integrationsMap.entrySet()) {
                String string = object.getKey();
                Object options = object.getValue();
                Intrinsics.checkNotNull(options, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
                messageBuilder.integrationOptions(string, (Map)options);
            }
        }
        if ((context = args.get("--context")) != null) {
            Map<String, ?> contextMap = MainKt.parseJson((String)context);
            for (Map.Entry<String, ?> entry : contextMap.entrySet()) {
                String name2 = entry.getKey();
                Object options = entry.getValue();
                messageBuilder.context(contextMap);
            }
        }
        Object v7 = args.get("--writeKey");
        Intrinsics.checkNotNull(v7, (String)"null cannot be cast to non-null type kotlin.String");
        String writeKey = (String)v7;
        Phaser phaser = new Phaser(1);
        Analytics analytics2 = Analytics.builder((String)writeKey).flushQueueSize(1).callback(new Callback(phaser){
            final /* synthetic */ Phaser $phaser;
            {
                this.$phaser = $phaser;
            }

            public void success(@Nullable Message message) {
                this.$phaser.arrive();
            }

            public void failure(@Nullable Message message, @Nullable Throwable throwable) {
                Throwable throwable2 = throwable;
                Intrinsics.checkNotNull((Object)throwable2);
                throw throwable2;
            }
        }).build();
        try {
            phaser.register();
            analytics2.enqueue(messageBuilder);
            phaser.arriveAndAwaitAdvance();
        }
        finally {
            analytics2.shutdown();
        }
    }

    @NotNull
    public static final Map<String, ?> parseJson(@NotNull String k) {
        Intrinsics.checkNotNullParameter((Object)k, (String)"k");
        Type collectionType2 = new TypeToken<Map<String, ? extends Object>>(){}.getType();
        Object object = GSON.fromJson(k, collectionType2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (Map)object;
    }
}

