/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid.helpers.ips;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sendgrid.Method;
import com.sendgrid.Request;
import com.sendgrid.Response;
import com.sendgrid.SendGrid;
import com.sendgrid.helpers.ips.IPAddress;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class IPsHelper {
    private static final String ALL_IPS_ENDPOINT = "ips";

    public static List<String> getAllUnassignedIPs(SendGrid sendGrid) throws IOException {
        Request request = new Request();
        request.setMethod(Method.GET);
        request.setEndpoint(ALL_IPS_ENDPOINT);
        Response response = sendGrid.api(request);
        if (response != null && response.getStatusCode() == 200) {
            ArrayList<String> unassignedIPs = new ArrayList<String>();
            List ipAddressList = (List)new ObjectMapper().readValue(response.getBody(), (TypeReference)new TypeReference<List<IPAddress>>(){});
            for (IPAddress ipAddress : ipAddressList) {
                if (ipAddress.getSubUsers() != null && ipAddress.getSubUsers().size() != 0) continue;
                unassignedIPs.add(ipAddress.getIp());
            }
            return unassignedIPs;
        }
        return null;
    }
}

