/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional;

import com.shapesecurity.functional.F;
import com.shapesecurity.functional.data.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;

public final class Pair<A, B> {
    public final A left;
    public final B right;
    @Deprecated
    public final A a;
    @Deprecated
    public final B b;

    @NotNull
    public static <A, B> Pair<A, B> of(A left, B right) {
        return new Pair<A, B>(left, right);
    }

    @Deprecated
    @NotNull
    public static <A, B> Pair<A, B> make(A left, B right) {
        return Pair.of(left, right);
    }

    public Pair(A left, B right) {
        this.a = left;
        this.left = this.a;
        this.b = right;
        this.right = this.b;
    }

    public A left() {
        return this.left;
    }

    public B right() {
        return this.right;
    }

    @NotNull
    public Pair<B, A> swap() {
        return new Pair<B, A>(this.right, this.left);
    }

    @NotNull
    public <A1> Pair<A1, B> mapLeft(@NotNull F<A, A1> f) {
        return new Pair<A1, B>(f.apply(this.left), this.right);
    }

    @Deprecated
    @NotNull
    public <A1> Pair<A1, B> mapA(@NotNull F<A, A1> f) {
        return this.mapLeft(f);
    }

    @NotNull
    public <B1> Pair<A, B1> mapRight(@NotNull F<B, B1> f) {
        return new Pair<A, B1>(this.left, f.apply(this.right));
    }

    @Deprecated
    @NotNull
    public <B1> Pair<A, B1> mapB(@NotNull F<B, B1> f) {
        return this.mapRight(f);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Pair && ((Pair)obj).left.equals(this.left) && ((Pair)obj).right.equals(this.right);
    }

    public int hashCode() {
        int hash = HashCodeBuilder.put(HashCodeBuilder.init(), "Pair");
        hash = HashCodeBuilder.put(hash, this.left);
        return HashCodeBuilder.put(hash, this.right);
    }
}

