/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional;

import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Thunk<A> {
    @NotNull
    private final Supplier<A> supplier;
    @Nullable
    private volatile A value = null;

    private Thunk(@NotNull Supplier<A> supplier) {
        this.supplier = supplier;
    }

    @NotNull
    public static <A> Thunk<A> constant(@NotNull A value) {
        Thunk<Object> t = new Thunk<Object>(() -> value);
        t.value = value;
        return t;
    }

    @NotNull
    public static <A> Thunk<A> from(@NotNull Supplier<A> supplier) {
        return new Thunk<A>(supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final A get() {
        if (this.value == null) {
            Thunk thunk = this;
            synchronized (thunk) {
                if (this.value == null) {
                    A v = this.supplier.get();
                    this.value = v;
                    return v;
                }
                return this.value;
            }
        }
        return this.value;
    }
}

