/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.Effect;
import com.shapesecurity.functional.F;
import com.shapesecurity.functional.F2;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.functional.data.Monoid;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public abstract class ConcatList<T>
implements Iterable<T> {
    private static final Empty<Object> EMPTY = new Empty();
    private static BinaryTreeMonoid<Object> MONOID = new BinaryTreeMonoid();
    public final int length;

    protected ConcatList(int length) {
        this.length = length;
    }

    @NotNull
    public static <T> ConcatList<T> empty() {
        return EMPTY;
    }

    @Deprecated
    @NotNull
    public static <T> ConcatList<T> nil() {
        return ConcatList.empty();
    }

    @SafeVarargs
    public static <T> ConcatList<T> of(T head, T ... tail) {
        ConcatList<T> concatList = ConcatList.single(head);
        for (T t : tail) {
            concatList = concatList.append1(t);
        }
        return concatList;
    }

    @NotNull
    public static <T> ConcatList<T> single(@NotNull T scope) {
        return new Leaf(scope);
    }

    public static <T> Monoid<ConcatList<T>> monoid() {
        return MONOID;
    }

    @NotNull
    public final ImmutableList<T> toList() {
        return this.toList(ImmutableList.empty());
    }

    protected abstract ImmutableList<T> toList(@NotNull ImmutableList<T> var1);

    @NotNull
    public abstract <B> B foldLeft(@NotNull F2<B, ? super T, B> var1, @NotNull B var2);

    @NotNull
    public abstract <B> B foldRight(@NotNull F2<? super T, B, B> var1, @NotNull B var2);

    public abstract void foreach(@NotNull Effect<T> var1);

    public abstract boolean isEmpty();

    @NotNull
    public abstract ConcatList<T> append(@NotNull ConcatList<? extends T> var1);

    @NotNull
    public final ConcatList<T> append1(@NotNull T element) {
        return this.append(ConcatList.single(element));
    }

    public abstract boolean exists(@NotNull F<T, Boolean> var1);

    @NotNull
    public abstract Maybe<T> find(@NotNull F<T, Boolean> var1);

    @NotNull
    public abstract ConcatList<T> reverse();

    @NotNull
    public abstract Maybe<T> index(int var1);

    @NotNull
    public abstract Maybe<ConcatList<T>> update(int var1, @NotNull T var2);

    private static class BinaryTreeMonoid<T>
    implements Monoid<ConcatList<T>> {
        private BinaryTreeMonoid() {
        }

        @Override
        @NotNull
        public ConcatList<T> identity() {
            return new Empty();
        }

        @Override
        @NotNull
        public ConcatList<T> append(ConcatList<T> a, ConcatList<T> b) {
            return a.append(b);
        }
    }

    public static final class Fork<T>
    extends ConcatList<T> {
        @NotNull
        public final ConcatList<T> left;
        @NotNull
        public final ConcatList<T> right;

        private Fork(@NotNull ConcatList<T> left, @NotNull ConcatList<T> right) {
            super(left.length + right.length);
            this.left = left;
            this.right = right;
        }

        @Override
        @NotNull
        protected ImmutableList<T> toList(@NotNull ImmutableList<T> acc) {
            return this.left.toList(this.right.toList(acc));
        }

        @Override
        @NotNull
        public <B> B foldLeft(@NotNull F2<B, ? super T, B> f, @NotNull B init) {
            return this.right.foldLeft(f, this.left.foldLeft(f, init));
        }

        @Override
        @NotNull
        public <B> B foldRight(@NotNull F2<? super T, B, B> f, @NotNull B init) {
            return this.left.foldRight(f, this.right.foldRight(f, init));
        }

        @Override
        public void foreach(@NotNull Effect<T> f) {
            this.left.foreach(f);
            this.right.foreach(f);
        }

        @Override
        public boolean isEmpty() {
            return this.left.isEmpty() || this.right.isEmpty();
        }

        @Override
        @NotNull
        public ConcatList<T> append(@NotNull ConcatList<? extends T> rhs) {
            return new Fork<T>(this, rhs);
        }

        @Override
        public boolean exists(@NotNull F<T, Boolean> f) {
            return this.left.exists(f) || this.right.exists(f);
        }

        @Override
        @NotNull
        public Maybe<T> find(@NotNull F<T, Boolean> f) {
            Maybe<T> foundLeft = this.left.find(f);
            if (foundLeft.isNothing()) {
                return this.right.find(f);
            }
            return foundLeft;
        }

        @Override
        @NotNull
        public Fork<T> reverse() {
            return new Fork<T>(this.right.reverse(), this.left.reverse());
        }

        @Override
        @NotNull
        public Maybe<T> index(int index) {
            if (index >= this.length) {
                return Maybe.empty();
            }
            return index < this.left.length ? this.left.index(index) : this.right.index(index - this.left.length);
        }

        @Override
        @NotNull
        public Maybe<ConcatList<T>> update(int index, @NotNull T element) {
            if (index >= this.length) {
                return Maybe.empty();
            }
            ConcatList<T> left = this.left;
            ConcatList<T> right = this.right;
            if (index < this.left.length) {
                left = left.update(index, element).fromJust();
            } else {
                right = right.update(index - this.left.length, element).fromJust();
            }
            return Maybe.of(left.append(right));
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private boolean isLeft = true;
                private Iterator<T> branchIterator;
                {
                    this.branchIterator = left.iterator();
                }

                private void ensureCorrectBranch() {
                    if (this.isLeft && !this.branchIterator.hasNext()) {
                        this.isLeft = false;
                        this.branchIterator = right.iterator();
                    }
                }

                @Override
                public boolean hasNext() {
                    this.ensureCorrectBranch();
                    return this.branchIterator.hasNext();
                }

                @Override
                public T next() {
                    this.ensureCorrectBranch();
                    return this.branchIterator.next();
                }
            };
        }
    }

    public static final class Leaf<T>
    extends ConcatList<T> {
        @NotNull
        public final T data;

        private Leaf(@NotNull T data) {
            super(1);
            this.data = data;
        }

        @Override
        @NotNull
        protected ImmutableList<T> toList(@NotNull ImmutableList<T> acc) {
            return acc.cons(this.data);
        }

        @Override
        @NotNull
        public <B> B foldLeft(@NotNull F2<B, ? super T, B> f, @NotNull B init) {
            return f.apply(init, this.data);
        }

        @Override
        @NotNull
        public <B> B foldRight(@NotNull F2<? super T, B, B> f, @NotNull B init) {
            return f.apply(this.data, init);
        }

        @Override
        public void foreach(@NotNull Effect<T> f) {
            f.apply((Object)this.data);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        @NotNull
        public ConcatList<T> append(@NotNull ConcatList<? extends T> rhs) {
            return new Fork(this, rhs);
        }

        @Override
        public boolean exists(@NotNull F<T, Boolean> f) {
            return f.apply(this.data);
        }

        @Override
        @NotNull
        public Maybe<T> find(@NotNull F<T, Boolean> f) {
            if (f.apply(this.data).booleanValue()) {
                return Maybe.of(this.data);
            }
            return Maybe.empty();
        }

        @Override
        @NotNull
        public ConcatList<T> reverse() {
            return this;
        }

        @Override
        @NotNull
        public Maybe<T> index(int index) {
            return Maybe.iff(index == 0, this.data);
        }

        @Override
        @NotNull
        public Maybe<ConcatList<T>> update(int index, @NotNull T element) {
            return index == 0 ? Maybe.of(Leaf.single(element)) : Maybe.empty();
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private boolean used = false;

                @Override
                public boolean hasNext() {
                    return !this.used;
                }

                @Override
                public T next() {
                    if (!this.used) {
                        this.used = true;
                        return data;
                    }
                    return null;
                }
            };
        }
    }

    public static final class Empty<T>
    extends ConcatList<T> {
        private Empty() {
            super(0);
        }

        @Override
        @NotNull
        protected ImmutableList<T> toList(@NotNull ImmutableList<T> acc) {
            return acc;
        }

        @Override
        @NotNull
        public <B> B foldLeft(@NotNull F2<B, ? super T, B> f, @NotNull B init) {
            return init;
        }

        @Override
        @NotNull
        public <B> B foldRight(@NotNull F2<? super T, B, B> f, @NotNull B init) {
            return init;
        }

        @Override
        public void foreach(@NotNull Effect<T> f) {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public ConcatList<T> append(@NotNull ConcatList<? extends T> rhs) {
            return rhs;
        }

        @Override
        public boolean exists(@NotNull F<T, Boolean> f) {
            return false;
        }

        @Override
        @NotNull
        public Maybe<T> find(@NotNull F<T, Boolean> f) {
            return Maybe.empty();
        }

        @Override
        @NotNull
        public ConcatList<T> reverse() {
            return this;
        }

        @Override
        @NotNull
        public Maybe<T> index(int index) {
            return Maybe.empty();
        }

        @Override
        @NotNull
        public Maybe<ConcatList<T>> update(int index, @NotNull T element) {
            return Maybe.empty();
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public T next() {
                    return null;
                }
            };
        }
    }
}

