/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.Effect;
import com.shapesecurity.functional.F;
import com.shapesecurity.functional.F2;
import com.shapesecurity.functional.Pair;
import com.shapesecurity.functional.Thunk;
import com.shapesecurity.functional.data.ImmutableSet;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.functional.data.Nil;
import com.shapesecurity.functional.data.NonEmptyImmutableList;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public abstract class ImmutableList<A>
implements Iterable<A> {
    private static final ImmutableList<Object> EMPTY = new Nil<Object>();
    @NotNull
    private final Thunk<Integer> hashCodeThunk = Thunk.from(this::calcHashCode);
    public final int length;

    ImmutableList(int length) {
        this.length = length;
    }

    @NotNull
    public static <A> ImmutableList<A> from(@NotNull List<A> arrayList) {
        ImmutableList l = ImmutableList.empty();
        int size = arrayList.size();
        for (int i = size - 1; i >= 0; --i) {
            l = ImmutableList.cons(arrayList.get(i), l);
        }
        return l;
    }

    @Deprecated
    @NotNull
    public static <A> ImmutableList<A> list(@NotNull List<A> arrayList) {
        return ImmutableList.from(arrayList);
    }

    public static <T> NonEmptyImmutableList<T> cons(@NotNull T head, @NotNull ImmutableList<T> tail) {
        return new NonEmptyImmutableList<T>(head, tail);
    }

    public static <T> ImmutableList<T> empty() {
        return EMPTY;
    }

    @Deprecated
    public static <T> ImmutableList<T> nil() {
        return ImmutableList.empty();
    }

    @Deprecated
    public static <T> ImmutableList<T> list() {
        return ImmutableList.empty();
    }

    @SafeVarargs
    @NotNull
    public static <T> NonEmptyImmutableList<T> of(@NotNull T head, T ... el) {
        if (el.length == 0) {
            return ImmutableList.cons(head, ImmutableList.empty());
        }
        NonEmptyImmutableList<T> l = ImmutableList.cons(el[el.length - 1], ImmutableList.empty());
        for (int i = el.length - 2; i >= 0; --i) {
            l = ImmutableList.cons(el[i], l);
        }
        return ImmutableList.cons(head, l);
    }

    @SafeVarargs
    @NotNull
    public static <A> ImmutableList<A> from(A ... el) {
        return ImmutableList.fromBounded(el, 0, el.length);
    }

    @SafeVarargs
    @Deprecated
    @NotNull
    public static <T> NonEmptyImmutableList<T> list(@NotNull T head, T ... el) {
        return ImmutableList.of(head, el);
    }

    @NotNull
    public static <A> ImmutableList<A> fromBounded(@NotNull A[] el, int start, int end) {
        if (end == start) {
            return ImmutableList.empty();
        }
        NonEmptyImmutableList<A> l = ImmutableList.cons(el[end - 1], ImmutableList.empty());
        for (int i = end - 2; i >= start; --i) {
            l = ImmutableList.cons(el[i], l);
        }
        return l;
    }

    protected abstract int calcHashCode();

    public final int hashCode() {
        return this.hashCodeThunk.get();
    }

    @Override
    public Iterator<A> iterator() {
        return new Iterator<A>(){
            private ImmutableList<A> curr;
            {
                this.curr = ImmutableList.this;
            }

            @Override
            public boolean hasNext() {
                return !this.curr.isEmpty();
            }

            @Override
            public A next() {
                if (this.curr.isEmpty()) {
                    throw new NoSuchElementException();
                }
                Object head = this.curr.maybeHead().fromJust();
                this.curr = this.curr.maybeTail().fromJust();
                return head;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @NotNull
    public final NonEmptyImmutableList<A> cons(@NotNull A left) {
        return ImmutableList.cons(left, this);
    }

    @NotNull
    public abstract <B> B foldLeft(@NotNull F2<B, ? super A, B> var1, @NotNull B var2);

    @NotNull
    public abstract <B> B foldRight(@NotNull F2<? super A, B, B> var1, @NotNull B var2);

    @NotNull
    public abstract Maybe<A> maybeHead();

    @NotNull
    public abstract Maybe<A> maybeLast();

    @NotNull
    public abstract Maybe<ImmutableList<A>> maybeTail();

    @NotNull
    public abstract Maybe<ImmutableList<A>> maybeInit();

    @NotNull
    public abstract ImmutableList<A> filter(@NotNull F<A, Boolean> var1);

    @NotNull
    public abstract <B> ImmutableList<B> map(@NotNull F<A, B> var1);

    @NotNull
    public abstract <B> ImmutableList<B> mapWithIndex(@NotNull F2<Integer, A, B> var1);

    @NotNull
    public abstract ImmutableList<A> take(int var1);

    @NotNull
    public abstract ImmutableList<A> drop(int var1);

    @NotNull
    public abstract Maybe<NonEmptyImmutableList<A>> toNonEmptyList();

    @NotNull
    public abstract <B> Maybe<B> decons(@NotNull F2<A, ImmutableList<A>, B> var1);

    @NotNull
    public abstract <B, C> ImmutableList<C> zipWith(@NotNull F2<A, B, C> var1, @NotNull ImmutableList<B> var2);

    @NotNull
    public final A[] toArray(@NotNull A[] target) {
        int length = this.length;
        if (target.length < length) {
            target = (Object[])Array.newInstance(target.getClass().getComponentType(), length);
        }
        ImmutableList<A> l = this;
        for (int i = 0; i < length; ++i) {
            target[i] = l.maybeHead().fromJust();
            l = l.maybeTail().fromJust();
        }
        return target;
    }

    @NotNull
    public final A[] toArray(@NotNull F<Integer, A[]> constructor) {
        int length = this.length;
        A[] target = constructor.apply(length);
        return this.toArray(target);
    }

    public final void foreach(@NotNull Effect<A> f) {
        Maybe<A> head;
        ImmutableList<A> list = this;
        while ((head = list.maybeHead()).isJust()) {
            f.e(head.fromJust());
            list = list.maybeTail().fromJust();
        }
    }

    public abstract boolean isEmpty();

    @NotNull
    public abstract <B extends A> ImmutableList<A> append(@NotNull ImmutableList<B> var1);

    public abstract boolean exists(@NotNull F<A, Boolean> var1);

    public abstract boolean contains(@NotNull A var1);

    @NotNull
    public abstract Pair<ImmutableList<A>, ImmutableList<A>> span(@NotNull F<A, Boolean> var1);

    @NotNull
    public final <B> ImmutableList<B> bind(@NotNull F<A, ImmutableList<B>> f) {
        return this.flatMap(f);
    }

    @NotNull
    public abstract <B> ImmutableList<B> flatMap(@NotNull F<A, ImmutableList<B>> var1);

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @NotNull
    public final Maybe<A> find(@NotNull F<A, Boolean> f) {
        ImmutableList self = this;
        while (self instanceof NonEmptyImmutableList) {
            NonEmptyImmutableList selfNel = (NonEmptyImmutableList)self;
            boolean result = f.apply(selfNel.head);
            if (result) {
                return Maybe.of(selfNel.head);
            }
            self = selfNel.tail();
        }
        return Maybe.empty();
    }

    @NotNull
    public final <B> Maybe<B> findMap(@NotNull F<A, Maybe<B>> f) {
        ImmutableList self = this;
        while (self instanceof NonEmptyImmutableList) {
            NonEmptyImmutableList selfNel = (NonEmptyImmutableList)self;
            Maybe<B> result = f.apply(selfNel.head);
            if (result.isJust()) {
                return result;
            }
            self = selfNel.tail();
        }
        return Maybe.empty();
    }

    @NotNull
    public abstract ImmutableList<A> removeAll(@NotNull F<A, Boolean> var1);

    @NotNull
    public abstract ImmutableList<A> reverse();

    @NotNull
    public <B extends A> ImmutableList<A> patch(int index, int patchLength, @NotNull ImmutableList<B> replacements) {
        return this.take(index).append(replacements).append(this.drop(index + patchLength));
    }

    @NotNull
    public abstract <B, C> Pair<B, ImmutableList<C>> mapAccumL(@NotNull F2<B, A, Pair<B, C>> var1, @NotNull B var2);

    @NotNull
    public final Maybe<A> index(int index) {
        ImmutableList<A> l = this;
        if (index < 0) {
            return Maybe.empty();
        }
        while (index > 0) {
            if (l.isEmpty()) {
                return Maybe.empty();
            }
            --index;
            l = l.maybeTail().fromJust();
        }
        return l.maybeHead();
    }

    @NotNull
    public abstract ImmutableSet<A> uniqByEquality();

    @NotNull
    public abstract ImmutableSet<A> uniqByIdentity();

    @NotNull
    public abstract <B> ImmutableSet<A> uniqByEqualityOn(@NotNull F<A, B> var1);

    public abstract boolean equals(Object var1);
}

