/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.F2;
import com.shapesecurity.functional.Unit;
import com.shapesecurity.functional.data.HashTable;
import com.shapesecurity.functional.data.ImmutableList;
import org.jetbrains.annotations.NotNull;

public class ImmutableSet<T> {
    @NotNull
    private final HashTable<T, Unit> data;

    private ImmutableSet(@NotNull HashTable<T, Unit> data) {
        this.data = data;
    }

    public static <T> ImmutableSet<T> emptyUsingEquality() {
        return new ImmutableSet(HashTable.emptyUsingEquality());
    }

    public static <T> ImmutableSet<T> emptyUsingIdentity() {
        return new ImmutableSet(HashTable.emptyUsingIdentity());
    }

    @Deprecated
    public static <T> ImmutableSet<T> empty() {
        return ImmutableSet.emptyUsingEquality();
    }

    @Deprecated
    public static <T> ImmutableSet<T> emptyP() {
        return ImmutableSet.emptyUsingIdentity();
    }

    public <B extends T> ImmutableSet<T> put(@NotNull B datum) {
        return new ImmutableSet<T>(this.data.put(datum, Unit.unit));
    }

    @NotNull
    public <B extends T> ImmutableSet<T> putAll(@NotNull ImmutableList<B> list) {
        return list.foldLeft(ImmutableSet::put, this);
    }

    public boolean contains(@NotNull T datum) {
        return this.data.containsKey(datum);
    }

    public ImmutableSet<T> remove(@NotNull T datum) {
        return new ImmutableSet<T>(this.data.remove(datum));
    }

    public <A> A foldAbelian(@NotNull F2<T, A, A> f, @NotNull A init) {
        return (A)this.data.foldRight((p, acc) -> f.apply(p.left, acc), init);
    }

    public ImmutableSet<T> union(@NotNull ImmutableSet<T> other) {
        return new ImmutableSet<T>(this.data.merge(other.data));
    }

    public ImmutableList<T> toList() {
        return this.foldAbelian((v, acc) -> acc.cons(v), ImmutableList.empty());
    }

    public boolean equals(Object other) {
        return other instanceof ImmutableSet && this.data.length == ((ImmutableSet)other).data.length && this.data.foldLeft((memo, pair) -> memo != false && ((ImmutableSet)other).data.containsKey(pair.left), true) != false;
    }
}

