/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.Effect;
import com.shapesecurity.functional.F;
import com.shapesecurity.functional.Thunk;
import com.shapesecurity.functional.data.HashCodeBuilder;
import com.shapesecurity.functional.data.ImmutableList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Maybe<A> {
    private static final Maybe<Object> NOTHING = new Nothing<Object>();

    private Maybe() {
    }

    @NotNull
    public static <A> Maybe<A> empty() {
        return NOTHING;
    }

    @Deprecated
    @NotNull
    public static <A> Maybe<A> nothing() {
        return Maybe.empty();
    }

    @NotNull
    public static <A> Maybe<A> of(@NotNull A a) {
        return new Just(a);
    }

    @Deprecated
    @NotNull
    public static <A> Maybe<A> just(@NotNull A a) {
        return Maybe.of(a);
    }

    @NotNull
    public static <A> Maybe<A> fromNullable(@Nullable A a) {
        if (a == null) {
            return Maybe.empty();
        }
        return Maybe.of(a);
    }

    @Nullable
    public abstract A toNullable();

    public static <A> Maybe<A> join(@NotNull Maybe<Maybe<A>> m) {
        return m.flatMap(a -> a);
    }

    @NotNull
    public static <A> ImmutableList<A> catMaybes(@NotNull ImmutableList<Maybe<A>> l) {
        return l.foldRight((a, b) -> a.maybe(b, c -> ImmutableList.cons(c, b)), ImmutableList.empty());
    }

    @NotNull
    public static <A, B> ImmutableList<B> mapMaybe(@NotNull F<A, B> f, @NotNull ImmutableList<Maybe<A>> l) {
        return l.foldRight((a, b) -> a.maybe(b, v -> ImmutableList.cons(f.apply(v), b)), ImmutableList.empty());
    }

    @NotNull
    public static <A> Maybe<A> iff(boolean test, @NotNull A a) {
        if (test) {
            return Maybe.of(a);
        }
        return Maybe.empty();
    }

    public abstract boolean eq(@NotNull Maybe<A> var1);

    public final boolean equals(Object obj) {
        return obj == this || obj instanceof Maybe && this.eq((Maybe)obj);
    }

    public abstract int hashCode();

    @NotNull
    public abstract A fromJust() throws NullPointerException;

    @Deprecated
    @NotNull
    public abstract A just() throws NullPointerException;

    @NotNull
    public abstract <B> B maybe(@NotNull B var1, @NotNull F<A, B> var2);

    public final void foreach(@NotNull Effect<A> f) {
        this.map(f);
    }

    public abstract boolean isJust();

    public final boolean isNothing() {
        return !this.isJust();
    }

    @NotNull
    public abstract ImmutableList<A> toList();

    @NotNull
    public abstract A orJust(@NotNull A var1);

    @NotNull
    public abstract A orJustLazy(@NotNull Thunk<A> var1);

    @NotNull
    public abstract <B> Maybe<B> map(@NotNull F<A, B> var1);

    @NotNull
    public final <B> Maybe<B> bind(@NotNull F<A, Maybe<B>> f) {
        return this.flatMap(f);
    }

    @NotNull
    public abstract <B> Maybe<B> flatMap(@NotNull F<A, Maybe<B>> var1);

    @NotNull
    public abstract Maybe<A> filter(@NotNull F<A, Boolean> var1);

    private static class Nothing<A>
    extends Maybe<A> {
        private static final int HASH_CODE = HashCodeBuilder.put(HashCodeBuilder.init(), "Nothing");

        private Nothing() {
        }

        @Override
        @Nullable
        public A toNullable() {
            return null;
        }

        @Override
        public boolean eq(@NotNull Maybe<A> maybe) {
            return maybe == this;
        }

        @Override
        public final int hashCode() {
            return HASH_CODE;
        }

        @Override
        @NotNull
        public A fromJust() throws NullPointerException {
            throw new NullPointerException("Maybe.fromJust failed");
        }

        @Override
        @Deprecated
        @NotNull
        public A just() throws NullPointerException {
            return this.fromJust();
        }

        @Override
        @NotNull
        public <B> B maybe(@NotNull B def, @NotNull F<A, B> f) {
            return def;
        }

        @Override
        public boolean isJust() {
            return false;
        }

        @Override
        @NotNull
        public ImmutableList<A> toList() {
            return ImmutableList.empty();
        }

        @Override
        @NotNull
        public A orJust(@NotNull A a) {
            return a;
        }

        @Override
        @NotNull
        public A orJustLazy(@NotNull Thunk<A> a) {
            return a.get();
        }

        @Override
        @NotNull
        public <B> Maybe<B> map(@NotNull F<A, B> f) {
            return NOTHING;
        }

        @Override
        @NotNull
        public <B> Maybe<B> flatMap(@NotNull F<A, Maybe<B>> f) {
            return NOTHING;
        }

        @Override
        @NotNull
        public Maybe<A> filter(@NotNull F<A, Boolean> f) {
            return this;
        }
    }

    private static class Just<A>
    extends Maybe<A> {
        @NotNull
        private final A value;
        private Thunk<Integer> hashCodeThunk = Thunk.from(this::calcHashCode);

        private Just(@NotNull A value) {
            this.value = value;
        }

        private int calcHashCode() {
            return HashCodeBuilder.put(this.value.hashCode(), "Just");
        }

        @Override
        @Nullable
        public A toNullable() {
            return this.value;
        }

        @Override
        public boolean eq(@NotNull Maybe<A> maybe) {
            return maybe instanceof Just && maybe.fromJust().equals(this.value);
        }

        @Override
        public int hashCode() {
            return this.hashCodeThunk.get();
        }

        @Override
        @NotNull
        public A fromJust() throws NullPointerException {
            return this.value;
        }

        @Override
        @Deprecated
        @NotNull
        public A just() throws NullPointerException {
            return this.fromJust();
        }

        @Override
        @NotNull
        public <B> B maybe(@NotNull B def, @NotNull F<A, B> f) {
            return f.apply(this.value);
        }

        @Override
        public boolean isJust() {
            return true;
        }

        @Override
        @NotNull
        public ImmutableList<A> toList() {
            return ImmutableList.cons(this.value, ImmutableList.empty());
        }

        @Override
        @NotNull
        public A orJust(@NotNull A a) {
            return this.value;
        }

        @Override
        @NotNull
        public A orJustLazy(@NotNull Thunk<A> a) {
            return this.value;
        }

        @Override
        @NotNull
        public <B> Maybe<B> map(@NotNull F<A, B> f) {
            return Maybe.of(f.apply(this.value));
        }

        @Override
        @NotNull
        public <B> Maybe<B> flatMap(@NotNull F<A, Maybe<B>> f) {
            return f.apply(this.value);
        }

        @Override
        @NotNull
        public Maybe<A> filter(@NotNull F<A, Boolean> f) {
            return f.apply(this.value) != false ? this : Maybe.empty();
        }
    }
}

