/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.F;
import com.shapesecurity.functional.F2;
import com.shapesecurity.functional.Pair;
import com.shapesecurity.functional.data.HashCodeBuilder;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.ImmutableSet;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.functional.data.Nil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class NonEmptyImmutableList<T>
extends ImmutableList<T> {
    @NotNull
    public final T head;
    @NotNull
    public final ImmutableList<T> tail;

    protected NonEmptyImmutableList(@NotNull T head, @NotNull ImmutableList<T> tail) {
        super(tail.length + 1);
        this.head = head;
        this.tail = tail;
    }

    @NotNull
    public ImmutableList<T> tail() {
        return this.tail;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NonEmptyImmutableList)) {
            return false;
        }
        NonEmptyImmutableList list = (NonEmptyImmutableList)o;
        return this.head.equals(list.head) && this.tail().equals(list.tail());
    }

    @Override
    @NotNull
    public <A> A foldLeft(@NotNull F2<A, ? super T, A> f, @NotNull A init) {
        ImmutableList list = this;
        while (list instanceof NonEmptyImmutableList) {
            init = f.apply(init, list.head);
            list = list.tail();
        }
        return init;
    }

    @Override
    @NotNull
    public <A> A foldRight(@NotNull F2<? super T, A, A> f, @NotNull A init) {
        return f.apply(this.head, this.tail().foldRight(f, init));
    }

    @NotNull
    public T reduceLeft(@NotNull F2<T, ? super T, T> f) {
        return this.tail.foldLeft(f, this.head);
    }

    @NotNull
    public T reduceRight(@NotNull F2<? super T, T, T> f) {
        return this.init().foldRight(f, this.last());
    }

    @Override
    @NotNull
    public Maybe<T> maybeHead() {
        return Maybe.of(this.head);
    }

    @Override
    @NotNull
    public Maybe<T> maybeLast() {
        if (this.tail().isEmpty()) {
            return Maybe.of(this.head);
        }
        return this.tail().maybeLast();
    }

    @Override
    @NotNull
    public Maybe<ImmutableList<T>> maybeTail() {
        return Maybe.of(this.tail());
    }

    @Override
    @NotNull
    public Maybe<ImmutableList<T>> maybeInit() {
        if (this.tail().isEmpty()) {
            return Maybe.of(NonEmptyImmutableList.empty());
        }
        return this.tail().maybeInit().map((A t) -> t.cons(this.head));
    }

    @NotNull
    public final T last() {
        NonEmptyImmutableList nel = this;
        while (!nel.tail().isEmpty()) {
            nel = (NonEmptyImmutableList)nel.tail();
        }
        return nel.head;
    }

    @NotNull
    public final ImmutableList<T> init() {
        if (this.tail().isEmpty()) {
            return NonEmptyImmutableList.empty();
        }
        return NonEmptyImmutableList.cons(this.head, ((NonEmptyImmutableList)this.tail()).init());
    }

    @Override
    @NotNull
    public ImmutableList<T> filter(@NotNull F<T, Boolean> f) {
        Object[] result = new Object[this.length];
        ImmutableList list = this;
        int j = 0;
        for (int i = 0; i < this.length; ++i) {
            T el = list.head;
            if (f.apply(el).booleanValue()) {
                result[j] = el;
                ++j;
            }
            list = list.tail;
        }
        return NonEmptyImmutableList.fromBounded(result, 0, j);
    }

    @Override
    @NotNull
    public <B> NonEmptyImmutableList<B> map(@NotNull F<T, B> f) {
        Object[] result = new Object[this.length];
        ImmutableList list = this;
        for (int i = 0; i < this.length; ++i) {
            result[i] = f.apply(list.head);
            list = list.tail;
        }
        return (NonEmptyImmutableList)NonEmptyImmutableList.from(result);
    }

    @Override
    @NotNull
    public final <B> NonEmptyImmutableList<B> mapWithIndex(@NotNull F2<Integer, T, B> f) {
        int length = this.length;
        Object[] result = new Object[length];
        ImmutableList list = this;
        for (int i = 0; i < length; ++i) {
            result[i] = f.apply(i, list.head);
            list = list.tail();
        }
        return (NonEmptyImmutableList)NonEmptyImmutableList.from(result);
    }

    @Override
    @NotNull
    public ImmutableList<T> take(int n) {
        if (n <= 0) {
            return NonEmptyImmutableList.empty();
        }
        Object[] result = new Object[n];
        ImmutableList list = this;
        for (int i = 0; i < n; ++i) {
            result[i] = list.head;
            list = list.tail;
        }
        return NonEmptyImmutableList.from(result);
    }

    @Override
    @NotNull
    public ImmutableList<T> drop(int n) {
        if (n <= 0) {
            return this;
        }
        ImmutableList list = this;
        while (n > 0) {
            if (!(list instanceof NonEmptyImmutableList)) continue;
            list = list.tail;
            --n;
        }
        return list;
    }

    @Override
    @NotNull
    public Maybe<NonEmptyImmutableList<T>> toNonEmptyList() {
        return Maybe.of(this);
    }

    @Override
    @NotNull
    public <B> Maybe<B> decons(@NotNull F2<T, ImmutableList<T>, B> f) {
        return Maybe.of(f.apply(this.head, this.tail()));
    }

    @Override
    @NotNull
    public <B, C> ImmutableList<C> zipWith(@NotNull F2<T, B, C> f, @NotNull ImmutableList<B> list) {
        ImmutableList list1 = this;
        ImmutableList<Object> list2 = list;
        int n = Math.min(list1.length, list2.length);
        Object[] result = new Object[n];
        for (int i = 0; i < n; ++i) {
            result[i] = f.apply(list1.head, ((NonEmptyImmutableList)list2).head);
            list1 = list1.tail;
            list2 = ((NonEmptyImmutableList)list2).tail;
        }
        return NonEmptyImmutableList.from(result);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @NotNull
    public <B extends T> ImmutableList<T> append(@NotNull ImmutableList<B> list) {
        if (list.length == 0) {
            return this;
        }
        Object[] copy = this.toArray(new Object[this.length]);
        ImmutableList<B> listT = list;
        for (int i = copy.length - 1; i >= 0; --i) {
            listT = NonEmptyImmutableList.cons(copy[i], listT);
        }
        return listT;
    }

    @Override
    public boolean exists(@NotNull F<T, Boolean> f) {
        NonEmptyImmutableList list = this;
        while (!f.apply(list.head).booleanValue()) {
            if (list.tail instanceof Nil) {
                return false;
            }
            list = (NonEmptyImmutableList)list.tail;
        }
        return true;
    }

    @Override
    public boolean contains(@NotNull T a) {
        NonEmptyImmutableList list = this;
        while (list.head != a) {
            if (list.tail instanceof Nil) {
                return false;
            }
            list = (NonEmptyImmutableList)list.tail;
        }
        return true;
    }

    @Override
    @NotNull
    public Pair<ImmutableList<T>, ImmutableList<T>> span(@NotNull F<T, Boolean> f) {
        T el;
        Object[] result = new Object[this.length];
        ImmutableList list = this;
        int j = 0;
        for (int i = 0; i < this.length && f.apply(el = list.head).booleanValue(); ++i) {
            result[j] = el;
            ++j;
            list = list.tail;
        }
        return new Pair<ImmutableList<T>, ImmutableList<T>>(NonEmptyImmutableList.fromBounded(result, 0, j), list);
    }

    @Override
    @NotNull
    public <B> ImmutableList<B> flatMap(@NotNull F<T, ImmutableList<B>> f) {
        ArrayList<T> result = new ArrayList<T>();
        ImmutableList list = this;
        while (list instanceof NonEmptyImmutableList) {
            ImmutableList<Object> bucket = f.apply(list.head);
            while (bucket instanceof NonEmptyImmutableList) {
                result.add(((NonEmptyImmutableList)bucket).head);
                bucket = ((NonEmptyImmutableList)bucket).tail;
            }
            list = list.tail;
        }
        return NonEmptyImmutableList.from(result);
    }

    @Override
    @NotNull
    public ImmutableList<T> removeAll(@NotNull F<T, Boolean> f) {
        return this.filter((F<T, Boolean>)((F<Object, Boolean>)x -> (Boolean)f.apply(x) == false));
    }

    @Override
    @NotNull
    public NonEmptyImmutableList<T> reverse() {
        Object[] result = new Object[this.length];
        ImmutableList list = this;
        for (int i = 0; i < this.length; ++i) {
            result[this.length - i - 1] = list.head;
            list = list.tail;
        }
        return (NonEmptyImmutableList)NonEmptyImmutableList.from(result);
    }

    @Override
    @NotNull
    public <B, C> Pair<B, ImmutableList<C>> mapAccumL(@NotNull F2<B, T, Pair<B, C>> f, @NotNull B acc) {
        Object[] result = new Object[this.length];
        ImmutableList list = this;
        for (int i = 0; i < this.length; ++i) {
            Pair<B, C> pair = f.apply(acc, list.head);
            acc = pair.left;
            result[i] = pair.right;
            list = list.tail;
        }
        return new Pair<B, ImmutableList<Object>>(acc, NonEmptyImmutableList.from(result));
    }

    @Override
    @NotNull
    public ImmutableSet<T> uniqByEquality() {
        return ImmutableSet.emptyUsingEquality().putAll(this);
    }

    @Override
    @NotNull
    public ImmutableSet<T> uniqByIdentity() {
        return ImmutableSet.emptyUsingIdentity().putAll(this);
    }

    @Override
    @NotNull
    public <B> ImmutableSet<T> uniqByEqualityOn(@NotNull F<T, B> f) {
        ImmutableSet<B> set = ImmutableSet.emptyUsingEquality().put(f.apply(this.head));
        ImmutableSet out = ImmutableSet.emptyUsingIdentity().put(this.head);
        ImmutableList<T> list = this.tail;
        for (int i = 1; i < this.length; ++i) {
            T a = ((NonEmptyImmutableList)list).head;
            B b = f.apply(a);
            if (!set.contains(b)) {
                out = out.put(a);
            }
            set = set.put(b);
            list = ((NonEmptyImmutableList)list).tail;
        }
        return out;
    }

    @Override
    protected int calcHashCode() {
        int start = HashCodeBuilder.init();
        start = HashCodeBuilder.put(start, "List");
        start = HashCodeBuilder.put(start, this.head);
        return HashCodeBuilder.put(start, this.tail);
    }
}

