/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.Effect;
import com.shapesecurity.functional.F;
import com.shapesecurity.functional.F2;
import com.shapesecurity.functional.Pair;
import com.shapesecurity.functional.data.ImmutableSet;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.functional.data.Nil;
import com.shapesecurity.functional.data.NonEmptyImmutableList;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@CheckReturnValue
public abstract class ImmutableList<A>
implements Iterable<A> {
    private static final ImmutableList<Object> EMPTY = new Nil<Object>();
    @Nullable
    private volatile Integer hashCode = null;
    public final int length;

    ImmutableList(int length) {
        this.length = length;
    }

    @Nonnull
    public static <A> ImmutableList<A> from(@Nonnull List<A> arrayList) {
        ImmutableList l = ImmutableList.empty();
        int size = arrayList.size();
        for (int i = size - 1; i >= 0; --i) {
            l = ImmutableList.cons(arrayList.get(i), l);
        }
        return l;
    }

    @Nonnull
    @Deprecated
    public static <A> ImmutableList<A> list(@Nonnull List<A> arrayList) {
        return ImmutableList.from(arrayList);
    }

    public static <T> NonEmptyImmutableList<T> cons(@Nonnull T head, @Nonnull ImmutableList<T> tail) {
        return new NonEmptyImmutableList<T>(head, tail);
    }

    public static <T> ImmutableList<T> empty() {
        return EMPTY;
    }

    @Deprecated
    public static <T> ImmutableList<T> nil() {
        return ImmutableList.empty();
    }

    @Deprecated
    public static <T> ImmutableList<T> list() {
        return ImmutableList.empty();
    }

    @Nonnull
    @SafeVarargs
    public static <T> NonEmptyImmutableList<T> of(@Nonnull T head, T ... el) {
        if (el.length == 0) {
            return ImmutableList.cons(head, ImmutableList.empty());
        }
        NonEmptyImmutableList<T> l = ImmutableList.cons(el[el.length - 1], ImmutableList.empty());
        for (int i = el.length - 2; i >= 0; --i) {
            l = ImmutableList.cons(el[i], l);
        }
        return ImmutableList.cons(head, l);
    }

    @Nonnull
    @SafeVarargs
    public static <A> ImmutableList<A> from(A ... el) {
        return ImmutableList.fromBounded(el, 0, el.length);
    }

    @Nonnull
    @SafeVarargs
    @Deprecated
    public static <T> NonEmptyImmutableList<T> list(@Nonnull T head, T ... el) {
        return ImmutableList.of(head, el);
    }

    @Nonnull
    public static <A> ImmutableList<A> fromBounded(@Nonnull A[] el, int start, int end) {
        if (end == start) {
            return ImmutableList.empty();
        }
        NonEmptyImmutableList<A> l = ImmutableList.cons(el[end - 1], ImmutableList.empty());
        for (int i = end - 2; i >= start; --i) {
            l = ImmutableList.cons(el[i], l);
        }
        return l;
    }

    protected abstract int calcHashCode();

    public final int hashCode() {
        Integer hashCodeCached = this.hashCode;
        if (hashCodeCached == null) {
            int hc = this.calcHashCode();
            this.hashCode = hc;
            return hc;
        }
        return hashCodeCached;
    }

    @Override
    public void forEach(@Nonnull Consumer<? super A> action) {
        ImmutableList list = this;
        while (list instanceof NonEmptyImmutableList) {
            Object head = ((NonEmptyImmutableList)list).head;
            action.accept(head);
            list = ((NonEmptyImmutableList)list).tail;
        }
    }

    @Override
    public Iterator<A> iterator() {
        return new Iterator<A>(){
            private ImmutableList<A> curr;
            {
                this.curr = ImmutableList.this;
            }

            @Override
            public boolean hasNext() {
                return !this.curr.isEmpty();
            }

            @Override
            public A next() {
                if (this.curr instanceof NonEmptyImmutableList) {
                    NonEmptyImmutableList nel = (NonEmptyImmutableList)this.curr;
                    this.curr = nel.tail;
                    return nel.head;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Nonnull
    public final NonEmptyImmutableList<A> cons(@Nonnull A left) {
        return ImmutableList.cons(left, this);
    }

    @Nonnull
    public abstract <B> B foldLeft(@Nonnull F2<B, ? super A, B> var1, @Nonnull B var2);

    @Nonnull
    public abstract <B> B foldRight(@Nonnull F2<? super A, B, B> var1, @Nonnull B var2);

    @Nonnull
    public abstract Maybe<A> maybeHead();

    @Nonnull
    public abstract Maybe<A> maybeLast();

    @Nonnull
    public abstract Maybe<ImmutableList<A>> maybeTail();

    @Nonnull
    public abstract Maybe<ImmutableList<A>> maybeInit();

    @Nonnull
    public abstract ImmutableList<A> filter(@Nonnull F<A, Boolean> var1);

    @Nonnull
    public abstract <B> ImmutableList<B> map(@Nonnull F<A, B> var1);

    @Nonnull
    public abstract <B> ImmutableList<B> mapWithIndex(@Nonnull F2<Integer, A, B> var1);

    @Nonnull
    public abstract ImmutableList<A> take(int var1);

    @Nonnull
    public abstract ImmutableList<A> drop(int var1);

    @Nonnull
    public abstract Maybe<NonEmptyImmutableList<A>> toNonEmptyList();

    @Nonnull
    public abstract <B> Maybe<B> decons(@Nonnull F2<A, ImmutableList<A>, B> var1);

    @Nonnull
    public abstract <B, C> ImmutableList<C> zipWith(@Nonnull F2<A, B, C> var1, @Nonnull ImmutableList<B> var2);

    @Nonnull
    public final A[] toArray(@Nonnull A[] target) {
        int length = this.length;
        if (target.length < length) {
            target = (Object[])Array.newInstance(target.getClass().getComponentType(), length);
        }
        ImmutableList l = this;
        for (int i = 0; i < length; ++i) {
            target[i] = ((NonEmptyImmutableList)l).head;
            l = ((NonEmptyImmutableList)l).tail;
        }
        return target;
    }

    @Nonnull
    public final A[] toArray(@Nonnull F<Integer, A[]> constructor) {
        int length = this.length;
        A[] target = constructor.apply(length);
        return this.toArray(target);
    }

    @Deprecated
    public final void foreach(@Nonnull Effect<A> f) {
        this.forEach((Consumer<? super A>)((Consumer<Object>)f::e));
    }

    public abstract boolean isEmpty();

    @Nonnull
    public abstract <B extends A> ImmutableList<A> append(@Nonnull ImmutableList<B> var1);

    public abstract boolean exists(@Nonnull F<A, Boolean> var1);

    public abstract boolean contains(@Nonnull A var1);

    @Nonnull
    public abstract Pair<ImmutableList<A>, ImmutableList<A>> span(@Nonnull F<A, Boolean> var1);

    @Nonnull
    public final <B> ImmutableList<B> bind(@Nonnull F<A, ImmutableList<B>> f) {
        return this.flatMap(f);
    }

    @Nonnull
    public abstract <B> ImmutableList<B> flatMap(@Nonnull F<A, ImmutableList<B>> var1);

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Nonnull
    public final Maybe<A> find(@Nonnull F<A, Boolean> f) {
        ImmutableList self = this;
        while (self instanceof NonEmptyImmutableList) {
            NonEmptyImmutableList selfNel = (NonEmptyImmutableList)self;
            boolean result = f.apply(selfNel.head);
            if (result) {
                return Maybe.of(selfNel.head);
            }
            self = selfNel.tail();
        }
        return Maybe.empty();
    }

    @Nonnull
    public final <B> Maybe<B> findMap(@Nonnull F<A, Maybe<B>> f) {
        ImmutableList self = this;
        while (self instanceof NonEmptyImmutableList) {
            NonEmptyImmutableList selfNel = (NonEmptyImmutableList)self;
            Maybe<B> result = f.apply(selfNel.head);
            if (result.isJust()) {
                return result;
            }
            self = selfNel.tail();
        }
        return Maybe.empty();
    }

    @Nonnull
    public abstract ImmutableList<A> removeAll(@Nonnull F<A, Boolean> var1);

    @Nonnull
    public abstract ImmutableList<A> reverse();

    @Nonnull
    public <B extends A> ImmutableList<A> patch(int index, int patchLength, @Nonnull ImmutableList<B> replacements) {
        return this.take(index).append(replacements).append(this.drop(index + patchLength));
    }

    @Nonnull
    public abstract <B, C> Pair<B, ImmutableList<C>> mapAccumL(@Nonnull F2<B, A, Pair<B, C>> var1, @Nonnull B var2);

    @Nonnull
    public final Maybe<A> index(int index) {
        ImmutableList l = this;
        if (index < 0) {
            return Maybe.empty();
        }
        while (index > 0) {
            if (l.isEmpty()) {
                return Maybe.empty();
            }
            --index;
            l = ((NonEmptyImmutableList)l).tail;
        }
        return l.maybeHead();
    }

    @Nonnull
    public abstract ImmutableSet<A> uniqByEquality();

    @Nonnull
    public abstract ImmutableSet<A> uniqByIdentity();

    @Nonnull
    public abstract <B> ImmutableSet<A> uniqByEqualityOn(@Nonnull F<A, B> var1);

    public abstract boolean equals(Object var1);

    @Nonnull
    public Pair<ImmutableList<A>, ImmutableList<A>> partition(@Nonnull Predicate<A> predicate) {
        Object[] result = new Object[this.length];
        int[] l = new int[]{0};
        int[] r = new int[]{this.length};
        this.forEach((Consumer<? super A>)((Consumer<Object>)a -> {
            if (predicate.test(a)) {
                int n = l[0];
                l[0] = n + 1;
                result[n] = a;
            } else {
                r[0] = r[0] - 1;
                result[r[0]] = a;
            }
        }));
        ImmutableList right = ImmutableList.empty();
        for (int i = l[0]; i < this.length; ++i) {
            right = right.cons(result[i]);
        }
        return Pair.of(ImmutableList.fromBounded(result, 0, l[0]), right);
    }
}

