/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.Unit;
import com.shapesecurity.functional.data.ConcatList;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.ImmutableSet;
import com.shapesecurity.functional.data.Semigroup;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

@CheckReturnValue
public interface Monoid<T>
extends Semigroup<T> {
    public static final UnitIdentity UNIT = new UnitIdentity();
    public static final IntegerAdditive INTEGER_ADDITIVE = new IntegerAdditive();
    public static final IntegerMultiplicative INTEGER_MULTIPLICATIVE = new IntegerMultiplicative();
    public static final StringConcat STRING_CONCAT = new StringConcat();
    public static final BooleanOr BOOLEAN_OR = new BooleanOr();
    public static final BooleanAnd BOOLEAN_AND = new BooleanAnd();

    @Nonnull
    public T identity();

    public static class ConcatListAppend<T>
    implements Monoid<ConcatList<T>> {
        @Override
        @Nonnull
        public ConcatList<T> append(ConcatList<T> ts, ConcatList<T> t1) {
            return ts.append(t1);
        }

        @Override
        @Nonnull
        public ConcatList<T> identity() {
            return ConcatList.empty();
        }
    }

    public static class ImmutableSetIdentityUnion<T>
    implements Monoid<ImmutableSet<T>> {
        @Override
        @Nonnull
        public ImmutableSet<T> append(ImmutableSet<T> ts, ImmutableSet<T> t1) {
            return ts.union(t1);
        }

        @Override
        @Nonnull
        public ImmutableSet<T> identity() {
            return ImmutableSet.emptyUsingIdentity();
        }
    }

    public static class ImmutableSetEqualityUnion<T>
    implements Monoid<ImmutableSet<T>> {
        @Override
        @Nonnull
        public ImmutableSet<T> append(ImmutableSet<T> ts, ImmutableSet<T> t1) {
            return ts.union(t1);
        }

        @Override
        @Nonnull
        public ImmutableSet<T> identity() {
            return ImmutableSet.emptyUsingEquality();
        }
    }

    public static class ImmutableListAppend<T>
    implements Monoid<ImmutableList<T>> {
        @Override
        @Nonnull
        public ImmutableList<T> append(ImmutableList<T> ts, ImmutableList<T> t1) {
            return ts.append(t1);
        }

        @Override
        @Nonnull
        public ImmutableList<T> identity() {
            return ImmutableList.empty();
        }
    }

    public static class BooleanAnd
    extends Semigroup.BooleanAnd
    implements Monoid<Boolean> {
        protected BooleanAnd() {
        }

        @Override
        @Nonnull
        public final Boolean identity() {
            return true;
        }
    }

    public static class BooleanOr
    extends Semigroup.BooleanOr
    implements Monoid<Boolean> {
        protected BooleanOr() {
        }

        @Override
        @Nonnull
        public final Boolean identity() {
            return false;
        }
    }

    public static class StringConcat
    extends Semigroup.StringConcat
    implements Monoid<String> {
        protected StringConcat() {
        }

        @Override
        @Nonnull
        public final String identity() {
            return "";
        }
    }

    public static class IntegerMultiplicative
    extends Semigroup.IntegerMultiplicative
    implements Monoid<Integer> {
        protected IntegerMultiplicative() {
        }

        @Override
        @Nonnull
        public final Integer identity() {
            return 1;
        }
    }

    public static class IntegerAdditive
    extends Semigroup.IntegerAdditive
    implements Monoid<Integer> {
        protected IntegerAdditive() {
        }

        @Override
        @Nonnull
        public final Integer identity() {
            return 0;
        }
    }

    public static class UnitIdentity
    extends Semigroup.UnitIdentity
    implements Monoid<Unit> {
        protected UnitIdentity() {
        }

        @Override
        @Nonnull
        public final Unit identity() {
            return Unit.unit;
        }
    }
}

