/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional;

import com.shapesecurity.functional.F;
import com.shapesecurity.functional.data.HashCodeBuilder;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

@CheckReturnValue
public final class Pair<A, B> {
    public final A left;
    public final B right;
    @Deprecated
    public final A a;
    @Deprecated
    public final B b;

    @Nonnull
    public static <A, B> Pair<A, B> of(A left, B right) {
        return new Pair<A, B>(left, right);
    }

    @Nonnull
    @Deprecated
    public static <A, B> Pair<A, B> make(A left, B right) {
        return Pair.of(left, right);
    }

    public Pair(A left, B right) {
        this.a = left;
        this.left = this.a;
        this.b = right;
        this.right = this.b;
    }

    public A left() {
        return this.left;
    }

    public B right() {
        return this.right;
    }

    @Nonnull
    public Pair<B, A> swap() {
        return new Pair<B, A>(this.right, this.left);
    }

    @Nonnull
    public <A1> Pair<A1, B> mapLeft(@Nonnull F<A, A1> f) {
        return new Pair<A1, B>(f.apply(this.left), this.right);
    }

    @Nonnull
    @Deprecated
    public <A1> Pair<A1, B> mapA(@Nonnull F<A, A1> f) {
        return this.mapLeft(f);
    }

    @Nonnull
    public <B1> Pair<A, B1> mapRight(@Nonnull F<B, B1> f) {
        return new Pair<A, B1>(this.left, f.apply(this.right));
    }

    @Nonnull
    @Deprecated
    public <B1> Pair<A, B1> mapB(@Nonnull F<B, B1> f) {
        return this.mapRight(f);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Pair && ((Pair)obj).left.equals(this.left) && ((Pair)obj).right.equals(this.right);
    }

    public int hashCode() {
        int hash = HashCodeBuilder.put(HashCodeBuilder.init(), "Pair");
        hash = HashCodeBuilder.put(hash, this.left);
        return HashCodeBuilder.put(hash, this.right);
    }
}

