/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.functional.data;

import com.shapesecurity.functional.F;
import com.shapesecurity.functional.F2;
import com.shapesecurity.functional.Pair;
import com.shapesecurity.functional.data.HashCodeBuilder;
import com.shapesecurity.functional.data.ImmutableList;
import com.shapesecurity.functional.data.ImmutableSet;
import com.shapesecurity.functional.data.Maybe;
import com.shapesecurity.functional.data.Nil;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public final class NonEmptyImmutableList<T>
extends ImmutableList<T> {
    public static final int HASH_START = HashCodeBuilder.put(HashCodeBuilder.init(), "List");
    @Nonnull
    public final T head;
    @Nonnull
    public final ImmutableList<T> tail;

    protected NonEmptyImmutableList(@Nonnull T head, @Nonnull ImmutableList<T> tail) {
        super(tail.length + 1);
        this.head = head;
        this.tail = tail;
    }

    @Nonnull
    public ImmutableList<T> tail() {
        return this.tail;
    }

    @Nonnull
    private T[] toObjectArray() {
        int length = this.length;
        Object[] target = new Object[length];
        return this.toArray(target);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NonEmptyImmutableList)) {
            return false;
        }
        ImmutableList l = this;
        ImmutableList<T> r = (ImmutableList<T>)o;
        if (l.length != r.length) {
            return false;
        }
        while (l instanceof NonEmptyImmutableList && r instanceof NonEmptyImmutableList) {
            if (l == r) {
                return true;
            }
            NonEmptyImmutableList nelL = l;
            NonEmptyImmutableList nelR = (NonEmptyImmutableList)r;
            if (!nelL.head.equals(nelR.head)) {
                return false;
            }
            l = nelL.tail;
            r = nelR.tail;
        }
        return l == r;
    }

    @Override
    @Nonnull
    public <A> A foldLeft(@Nonnull F2<A, ? super T, A> f, @Nonnull A init) {
        ImmutableList list = this;
        while (list instanceof NonEmptyImmutableList) {
            init = f.apply(init, list.head);
            list = list.tail();
        }
        return init;
    }

    @Override
    @Nonnull
    public <A> A foldRight(@Nonnull F2<? super T, A, A> f, @Nonnull A init) {
        T[] list = this.toObjectArray();
        for (int i = this.length - 1; i >= 0; --i) {
            init = f.apply(list[i], init);
        }
        return init;
    }

    @Nonnull
    public T reduceLeft(@Nonnull F2<T, ? super T, T> f) {
        return this.tail.foldLeft(f, this.head);
    }

    @Nonnull
    public T reduceRight(@Nonnull F2<? super T, T, T> f) {
        return ((NonEmptyImmutableList)this.reverse()).reduceLeft(f.flip());
    }

    @Override
    @Nonnull
    public Maybe<T> maybeHead() {
        return Maybe.of(this.head);
    }

    @Override
    @Nonnull
    public Maybe<T> maybeLast() {
        return Maybe.of(this.last());
    }

    @Override
    @Nonnull
    public Maybe<ImmutableList<T>> maybeTail() {
        return Maybe.of(this.tail);
    }

    @Override
    @Nonnull
    public Maybe<ImmutableList<T>> maybeInit() {
        return Maybe.of(this.init());
    }

    @Nonnull
    public T last() {
        NonEmptyImmutableList other = this;
        while (other.tail instanceof NonEmptyImmutableList) {
            other = (NonEmptyImmutableList)other.tail;
        }
        return other.head;
    }

    @Nonnull
    public ImmutableList<T> init() {
        return NonEmptyImmutableList.fromBounded(this.toObjectArray(), 0, this.length - 1);
    }

    @Override
    @Nonnull
    public ImmutableList<T> filter(@Nonnull F<T, Boolean> f) {
        Object[] result = new Object[this.length];
        ImmutableList list = this;
        int j = 0;
        for (int i = 0; i < this.length; ++i) {
            T el = list.head;
            if (f.apply(el).booleanValue()) {
                result[j] = el;
                ++j;
            }
            list = list.tail;
        }
        return NonEmptyImmutableList.fromBounded(result, 0, j);
    }

    @Override
    @Nonnull
    public <B> NonEmptyImmutableList<B> map(@Nonnull F<T, B> f) {
        Object[] result = new Object[this.length];
        ImmutableList list = this;
        for (int i = 0; i < this.length; ++i) {
            result[i] = f.apply(list.head);
            list = list.tail;
        }
        return (NonEmptyImmutableList)NonEmptyImmutableList.from(result);
    }

    @Override
    @Nonnull
    public final <B> NonEmptyImmutableList<B> mapWithIndex(@Nonnull F2<Integer, T, B> f) {
        int length = this.length;
        Object[] result = new Object[length];
        ImmutableList list = this;
        for (int i = 0; i < length; ++i) {
            result[i] = f.apply(i, list.head);
            list = list.tail();
        }
        return (NonEmptyImmutableList)NonEmptyImmutableList.from(result);
    }

    @Override
    @Nonnull
    public ImmutableList<T> take(int n) {
        if (n <= 0) {
            return NonEmptyImmutableList.empty();
        }
        Object[] result = new Object[n];
        ImmutableList list = this;
        for (int i = 0; i < n; ++i) {
            result[i] = list.head;
            list = list.tail;
        }
        return NonEmptyImmutableList.from(result);
    }

    @Override
    @Nonnull
    public ImmutableList<T> drop(int n) {
        if (n <= 0) {
            return this;
        }
        ImmutableList list = this;
        while (n > 0) {
            if (!(list instanceof NonEmptyImmutableList)) continue;
            list = list.tail;
            --n;
        }
        return list;
    }

    @Override
    @Nonnull
    public Maybe<NonEmptyImmutableList<T>> toNonEmptyList() {
        return Maybe.of(this);
    }

    @Override
    @Nonnull
    public <B> Maybe<B> decons(@Nonnull F2<T, ImmutableList<T>, B> f) {
        return Maybe.of(f.apply(this.head, this.tail()));
    }

    @Override
    @Nonnull
    public <B, C> ImmutableList<C> zipWith(@Nonnull F2<T, B, C> f, @Nonnull ImmutableList<B> list) {
        ImmutableList list1 = this;
        ImmutableList<Object> list2 = list;
        int n = Math.min(list1.length, list2.length);
        Object[] result = new Object[n];
        for (int i = 0; i < n; ++i) {
            result[i] = f.apply(list1.head, ((NonEmptyImmutableList)list2).head);
            list1 = list1.tail;
            list2 = ((NonEmptyImmutableList)list2).tail;
        }
        return NonEmptyImmutableList.from(result);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @Nonnull
    public <B extends T> ImmutableList<T> append(@Nonnull ImmutableList<B> list) {
        if (list.length == 0) {
            return this;
        }
        T[] copy = this.toObjectArray();
        ImmutableList<B> listT = list;
        for (int i = copy.length - 1; i >= 0; --i) {
            listT = NonEmptyImmutableList.cons(copy[i], listT);
        }
        return listT;
    }

    @Override
    public boolean exists(@Nonnull F<T, Boolean> f) {
        NonEmptyImmutableList list = this;
        while (!f.apply(list.head).booleanValue()) {
            if (list.tail instanceof Nil) {
                return false;
            }
            list = (NonEmptyImmutableList)list.tail;
        }
        return true;
    }

    @Override
    public boolean contains(@Nonnull T a) {
        NonEmptyImmutableList list = this;
        while (list.head != a) {
            if (list.tail instanceof Nil) {
                return false;
            }
            list = (NonEmptyImmutableList)list.tail;
        }
        return true;
    }

    @Override
    @Nonnull
    public Pair<ImmutableList<T>, ImmutableList<T>> span(@Nonnull F<T, Boolean> f) {
        T el;
        Object[] result = new Object[this.length];
        ImmutableList list = this;
        int j = 0;
        for (int i = 0; i < this.length && f.apply(el = list.head).booleanValue(); ++i) {
            result[j] = el;
            ++j;
            list = list.tail;
        }
        return new Pair<ImmutableList<T>, ImmutableList<T>>(NonEmptyImmutableList.fromBounded(result, 0, j), list);
    }

    @Override
    @Nonnull
    public <B> ImmutableList<B> flatMap(@Nonnull F<T, ImmutableList<B>> f) {
        ArrayList<T> result = new ArrayList<T>();
        ImmutableList list = this;
        while (list instanceof NonEmptyImmutableList) {
            ImmutableList<Object> bucket = f.apply(list.head);
            while (bucket instanceof NonEmptyImmutableList) {
                result.add(((NonEmptyImmutableList)bucket).head);
                bucket = ((NonEmptyImmutableList)bucket).tail;
            }
            list = list.tail;
        }
        return NonEmptyImmutableList.from(result);
    }

    @Override
    @Nonnull
    public ImmutableList<T> removeAll(@Nonnull F<T, Boolean> f) {
        return this.filter((F<T, Boolean>)((F<Object, Boolean>)x -> (Boolean)f.apply(x) == false));
    }

    @Override
    @Nonnull
    public NonEmptyImmutableList<T> reverse() {
        ImmutableList list = this;
        ImmutableList acc = NonEmptyImmutableList.empty();
        while (list instanceof NonEmptyImmutableList) {
            acc = acc.cons(list.head);
            list = list.tail;
        }
        return (NonEmptyImmutableList)acc;
    }

    @Override
    @Nonnull
    public <B, C> Pair<B, ImmutableList<C>> mapAccumL(@Nonnull F2<B, T, Pair<B, C>> f, @Nonnull B acc) {
        Object[] result = new Object[this.length];
        ImmutableList list = this;
        for (int i = 0; i < this.length; ++i) {
            Pair<B, C> pair = f.apply(acc, list.head);
            acc = pair.left;
            result[i] = pair.right;
            list = list.tail;
        }
        return new Pair<B, ImmutableList<Object>>(acc, NonEmptyImmutableList.from(result));
    }

    @Override
    @Nonnull
    public ImmutableSet<T> uniqByEquality() {
        return ImmutableSet.emptyUsingEquality().putAll(this);
    }

    @Override
    @Nonnull
    public ImmutableSet<T> uniqByIdentity() {
        return ImmutableSet.emptyUsingIdentity().putAll(this);
    }

    @Override
    @Nonnull
    public <B> ImmutableSet<T> uniqByEqualityOn(@Nonnull F<T, B> f) {
        ImmutableSet<B> set = ImmutableSet.emptyUsingEquality().put(f.apply(this.head));
        ImmutableSet out = ImmutableSet.emptyUsingIdentity().put(this.head);
        ImmutableList<T> list = this.tail;
        for (int i = 1; i < this.length; ++i) {
            T a = ((NonEmptyImmutableList)list).head;
            B b = f.apply(a);
            if (!set.contains(b)) {
                out = out.put(a);
            }
            set = set.put(b);
            list = ((NonEmptyImmutableList)list).tail;
        }
        return out;
    }

    @Override
    protected int calcHashCode() {
        int start = HASH_START;
        start = HashCodeBuilder.put(start, this.head);
        return HashCodeBuilder.put(start, this.tail);
    }
}

