/*
 * Decompiled with CFR 0.152.
 */
package com.shift4.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.shift4.response.Expandable;
import java.io.IOException;

public class ExpandableDeserializer
extends JsonDeserializer<Expandable<?>>
implements ContextualDeserializer {
    private JavaType objectType;

    public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) {
        ExpandableDeserializer deserializer = new ExpandableDeserializer();
        if (context != null && context.getContextualType() != null) {
            deserializer.objectType = context.getContextualType().containedType(0);
        } else if (property != null && property.getType() != null) {
            deserializer.objectType = property.getType().containedType(0);
        }
        return deserializer;
    }

    public Expandable<?> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        JsonNode node = (JsonNode)mapper.readTree(parser);
        if (node.isTextual()) {
            return new Expandable(node.textValue());
        }
        String id = this.getId(node);
        Object object = mapper.readValue(mapper.treeAsTokens((TreeNode)node), this.objectType);
        return new Expandable<Object>(id, object);
    }

    private String getId(JsonNode node) {
        JsonNode idNode = node.get("id");
        if (idNode == null || !idNode.isTextual()) {
            return null;
        }
        return idNode.textValue();
    }
}

