/*
 * Decompiled with CFR 0.152.
 */
package com.shift4.response;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.shift4.enums.CardBrand;
import com.shift4.enums.CardType;
import com.shift4.enums.PaymentMethodStatus;
import com.shift4.enums.PaymentMethodType;
import com.shift4.response.Billing;
import com.shift4.response.FraudCheckData;
import com.shift4.util.Shift4Utils;
import java.util.HashMap;
import java.util.Map;

public class PaymentMethod {
    private String id;
    private String customerId;
    private String clientObjectId;
    private Long created;
    private String type;
    private String status;
    private boolean deleted = false;
    private Billing billing;
    private FraudCheckData fraudCheckData;
    private ApplePay applePay;
    @JsonIgnore
    private final Map<String, Object> other = new HashMap<String, Object>();

    public String getId() {
        return this.id;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getClientObjectId() {
        return this.clientObjectId;
    }

    public Long getCreated() {
        return this.created;
    }

    public PaymentMethodType getType() {
        return PaymentMethodType.fromValue(this.type);
    }

    public String getTypeStr() {
        return this.type;
    }

    public PaymentMethodStatus getStatus() {
        return PaymentMethodStatus.fromValue(this.status);
    }

    public String getStatusStr() {
        return this.status;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public Billing getBilling() {
        return this.billing;
    }

    public FraudCheckData getFraudCheckData() {
        return this.fraudCheckData;
    }

    public ApplePay getApplePay() {
        return this.applePay;
    }

    public String get(String name) {
        return Shift4Utils.toStringNullSafe(this.other.get(name));
    }

    @JsonAnySetter
    private void set(String name, Object value) {
        this.other.put(name, value);
    }

    public static class ApplePay {
        private String cardBrand;
        private String cardType;
        private String first6;
        private String last4;
        private Integer amount;
        private String currency;
        @JsonIgnore
        private final Map<String, Object> other = new HashMap<String, Object>();

        public CardBrand getCardBrand() {
            return CardBrand.fromValue(this.cardBrand);
        }

        public String getCardBrandAsString() {
            return this.cardBrand;
        }

        public CardType getCardType() {
            return CardType.fromValue(this.cardType);
        }

        public String getCardTypeAsString() {
            return this.cardType;
        }

        public String getFirst6() {
            return this.first6;
        }

        public String getLast4() {
            return this.last4;
        }

        public Integer getAmount() {
            return this.amount;
        }

        public String getCurrency() {
            return this.currency;
        }

        public String get(String name) {
            return Shift4Utils.toStringNullSafe(this.other.get(name));
        }

        @JsonAnySetter
        private void set(String name, Object value) {
            this.other.put(name, value);
        }
    }
}

