/*
 * Decompiled with CFR 0.152.
 */
package com.shift4;

import com.shift4.Shift4GatewayHeadersFactory;
import com.shift4.connection.Connection;
import com.shift4.connection.Response;
import com.shift4.exception.Shift4Exception;
import com.shift4.request.Expand;
import com.shift4.request.RetrieveRequest;
import com.shift4.response.ErrorResponse;
import com.shift4.response.ListResponse;
import com.shift4.util.ObjectSerializer;
import java.io.File;
import java.io.IOException;
import java.util.Map;

class ConnectionClient {
    private final ObjectSerializer objectSerializer = ObjectSerializer.INSTANCE;
    private Shift4GatewayHeadersFactory headersFactory = new Shift4GatewayHeadersFactory();
    private Connection connection;
    private String secretKey;
    private String endpoint;

    ConnectionClient(Connection connection, String secretKey, String endpoint) {
        this.connection = connection;
        this.secretKey = secretKey;
        this.endpoint = endpoint;
    }

    <T> T get(String path, Class<T> responseClass) {
        return this.get(path, responseClass, null);
    }

    <T> T get(String path, Class<T> responseClass, Expand expand) {
        RetrieveRequest request = new RetrieveRequest().expand(expand);
        String url = this.buildQueryString(this.endpoint + path, request);
        Response response = this.connection.get(url, this.buildHeaders());
        this.ensureSuccess(response);
        return this.objectSerializer.deserialize(response.getBody(), responseClass);
    }

    <T> T post(String path, Object request, Class<T> responseClass) {
        String requestBody = this.objectSerializer.serialize(request);
        Response response = this.connection.post(this.endpoint + path, requestBody, this.buildHeaders());
        this.ensureSuccess(response);
        return this.objectSerializer.deserialize(response.getBody(), responseClass);
    }

    <T> T multipart(String path, Map<String, File> files, Map<String, String> form, Class<T> responseClass) {
        Response response = this.connection.multipart(this.endpoint + path, files, form, this.buildHeaders());
        this.ensureSuccess(response);
        return this.objectSerializer.deserialize(response.getBody(), responseClass);
    }

    <T> ListResponse<T> list(String path, Class<T> elementClass) {
        return this.list(path, null, elementClass);
    }

    <T> ListResponse<T> list(String path, Object request, Class<T> elementClass) {
        String url = this.buildQueryString(this.endpoint + path, request);
        Response response = this.connection.get(url, this.buildHeaders());
        this.ensureSuccess(response);
        return this.objectSerializer.deserializeList(response.getBody(), elementClass);
    }

    <T> T delete(String path, Class<T> responseClass) {
        return this.delete(path, null, responseClass);
    }

    <T> T delete(String path, Object request, Class<T> responseClass) {
        String url = this.buildQueryString(this.endpoint + path, request);
        Response response = this.connection.delete(url, this.buildHeaders());
        this.ensureSuccess(response);
        return this.objectSerializer.deserialize(response.getBody(), responseClass);
    }

    private void ensureSuccess(Response response) {
        if (response.getStatus() != 200) {
            ErrorResponse error = this.objectSerializer.deserialize(response.getBody(), ErrorResponse.class);
            throw new Shift4Exception(error);
        }
    }

    private String buildQueryString(String url, Object request) {
        if (request == null) {
            return url;
        }
        return url + this.objectSerializer.serializeToQueryString(request);
    }

    protected Map<String, String> buildHeaders() {
        return this.headersFactory.create(this.secretKey);
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setHeadersFactory(Shift4GatewayHeadersFactory headersFactory) {
        this.headersFactory = headersFactory;
    }

    void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

