/*
 * Decompiled with CFR 0.152.
 */
package com.shift4;

import com.shift4.ConnectionClient;
import com.shift4.Shift4GatewayHeadersFactory;
import com.shift4.connection.Connection;
import com.shift4.connection.HttpClientConnection;
import com.shift4.enums.FileUploadPurpose;
import com.shift4.exception.SignException;
import com.shift4.request.BlacklistRuleListRequest;
import com.shift4.request.BlacklistRuleRequest;
import com.shift4.request.CaptureRequest;
import com.shift4.request.CardListRequest;
import com.shift4.request.CardRequest;
import com.shift4.request.CardUpdateRequest;
import com.shift4.request.ChargeListRequest;
import com.shift4.request.ChargeRequest;
import com.shift4.request.ChargeUpdateRequest;
import com.shift4.request.CheckoutRequest;
import com.shift4.request.CreditListRequest;
import com.shift4.request.CreditRequest;
import com.shift4.request.CreditUpdateRequest;
import com.shift4.request.CustomerListRequest;
import com.shift4.request.CustomerRequest;
import com.shift4.request.CustomerUpdateRequest;
import com.shift4.request.DisputeListRequest;
import com.shift4.request.DisputeUpdateRequest;
import com.shift4.request.EventListRequest;
import com.shift4.request.Expand;
import com.shift4.request.FileUploadListRequest;
import com.shift4.request.FraudWarningListRequest;
import com.shift4.request.PaymentMethodListRequest;
import com.shift4.request.PaymentMethodRequest;
import com.shift4.request.PayoutListRequest;
import com.shift4.request.PayoutTransactionListRequest;
import com.shift4.request.PlanListRequest;
import com.shift4.request.PlanRequest;
import com.shift4.request.PlanUpdateRequest;
import com.shift4.request.RefundListRequest;
import com.shift4.request.RefundRequest;
import com.shift4.request.RefundUpdateRequest;
import com.shift4.request.RequestOptions;
import com.shift4.request.SubscriptionCancelRequest;
import com.shift4.request.SubscriptionListRequest;
import com.shift4.request.SubscriptionRequest;
import com.shift4.request.SubscriptionUpdateRequest;
import com.shift4.request.TokenRequest;
import com.shift4.response.BlacklistRule;
import com.shift4.response.Card;
import com.shift4.response.Charge;
import com.shift4.response.Credit;
import com.shift4.response.Customer;
import com.shift4.response.DeleteResponse;
import com.shift4.response.Dispute;
import com.shift4.response.Event;
import com.shift4.response.FileUpload;
import com.shift4.response.FraudWarning;
import com.shift4.response.ListResponse;
import com.shift4.response.PaymentMethod;
import com.shift4.response.Payout;
import com.shift4.response.PayoutTransaction;
import com.shift4.response.Plan;
import com.shift4.response.Refund;
import com.shift4.response.Subscription;
import com.shift4.response.Token;
import com.shift4.util.ObjectSerializer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class Shift4Gateway
implements Closeable {
    public static final String DEFAULT_ENDPOINT = "https://api.shift4.com";
    public static final String UPLOADS_ENDPOINT = "https://uploads.api.shift4.com";
    private static final String CHARGES_PATH = "/charges";
    private static final String TOKENS_PATH = "/tokens";
    private static final String CUSTOMERS_PATH = "/customers";
    private static final String CARDS_PATH = "/customers/%s/cards";
    private static final String PAYMENT_METHOD_PATH = "/payment-methods";
    private static final String PLANS_PATH = "/plans";
    private static final String SUBSCRIPTIONS_PATH = "/subscriptions";
    private static final String EVENTS_PATH = "/events";
    private static final String BLACKLIST_RULE_PATH = "/blacklist";
    private static final String CREDIT_PATH = "/credits";
    private static final String FILES_PATH = "/files";
    private static final String DISPUTES_PATH = "/disputes";
    private static final String FRAUD_WARNING_PATH = "/fraud-warnings";
    private static final String REFUND_PATH = "/refunds";
    private final ObjectSerializer objectSerializer = ObjectSerializer.INSTANCE;
    private final ConnectionClient gatewayClient;
    private final ConnectionClient gatewayUploadsClient;

    public Shift4Gateway() {
        this(null);
    }

    public Shift4Gateway(String secretKey) {
        this(secretKey, new HttpClientConnection());
    }

    public Shift4Gateway(String secretKey, String merchantId) {
        this(secretKey, merchantId, new HttpClientConnection());
    }

    public Shift4Gateway(String secretKey, Connection connection) {
        this.gatewayClient = new ConnectionClient(connection, secretKey, DEFAULT_ENDPOINT);
        this.gatewayUploadsClient = new ConnectionClient(connection, secretKey, UPLOADS_ENDPOINT);
    }

    public Shift4Gateway(String secretKey, String merchantId, Connection connection) {
        this.gatewayClient = new ConnectionClient(connection, secretKey, merchantId, DEFAULT_ENDPOINT);
        this.gatewayUploadsClient = new ConnectionClient(connection, secretKey, merchantId, UPLOADS_ENDPOINT);
    }

    public Charge createCharge(ChargeRequest request) {
        return this.post(CHARGES_PATH, request, Charge.class);
    }

    public Charge createCharge(ChargeRequest request, RequestOptions requestOptions) {
        return this.post(CHARGES_PATH, request, requestOptions, Charge.class);
    }

    public Charge captureCharge(CaptureRequest request) {
        return this.post("/charges/" + request.getChargeId() + "/capture", request, Charge.class);
    }

    public Charge captureCharge(CaptureRequest request, RequestOptions requestOptions) {
        return this.post("/charges/" + request.getChargeId() + "/capture", request, requestOptions, Charge.class);
    }

    public Charge retrieveCharge(String chargeId) {
        return this.get("/charges/" + chargeId, Charge.class);
    }

    public Charge updateCharge(ChargeUpdateRequest request) {
        return this.post("/charges/" + request.getChargeId(), request, Charge.class);
    }

    public Charge updateCharge(ChargeUpdateRequest request, RequestOptions requestOptions) {
        return this.post("/charges/" + request.getChargeId(), request, requestOptions, Charge.class);
    }

    public ListResponse<Charge> listCharges() {
        return this.list(CHARGES_PATH, Charge.class);
    }

    public ListResponse<Charge> listCharges(ChargeListRequest request) {
        return this.list(CHARGES_PATH, request, Charge.class);
    }

    public Customer createCustomer(CustomerRequest request) {
        return this.post(CUSTOMERS_PATH, request, Customer.class);
    }

    public Customer createCustomer(CustomerRequest request, RequestOptions requestOptions) {
        return this.post(CUSTOMERS_PATH, request, requestOptions, Customer.class);
    }

    public Customer retrieveCustomer(String customerId) {
        return this.get("/customers/" + customerId, Customer.class);
    }

    public Customer updateCustomer(CustomerUpdateRequest request) {
        return this.post("/customers/" + request.getCustomerId(), request, Customer.class);
    }

    public Customer updateCustomer(CustomerUpdateRequest request, RequestOptions requestOptions) {
        return this.post("/customers/" + request.getCustomerId(), request, requestOptions, Customer.class);
    }

    public DeleteResponse deleteCustomer(String customerId) {
        return this.delete("/customers/" + customerId, DeleteResponse.class);
    }

    public ListResponse<Customer> listCustomers() {
        return this.list(CUSTOMERS_PATH, Customer.class);
    }

    public ListResponse<Customer> listCustomers(CustomerListRequest request) {
        return this.list(CUSTOMERS_PATH, request, Customer.class);
    }

    public Card createCard(CardRequest request) {
        return this.post(String.format(CARDS_PATH, request.getCustomerId()), request, Card.class);
    }

    public Card createCard(CardRequest request, RequestOptions requestOptions) {
        return this.post(String.format(CARDS_PATH, request.getCustomerId()), request, requestOptions, Card.class);
    }

    public Card retrieveCard(String customerId, String cardId) {
        return this.get(String.format(CARDS_PATH, customerId) + "/" + cardId, Card.class);
    }

    public Card updateCard(CardUpdateRequest card) {
        return this.post(String.format(CARDS_PATH, card.getCustomerId()) + "/" + card.getCardId(), card, Card.class);
    }

    public Card updateCard(CardUpdateRequest card, RequestOptions requestOptions) {
        return this.post(String.format(CARDS_PATH, card.getCustomerId()) + "/" + card.getCardId(), card, requestOptions, Card.class);
    }

    public DeleteResponse deleteCard(String customerId, String cardId) {
        return this.delete(String.format(CARDS_PATH, customerId) + "/" + cardId, DeleteResponse.class);
    }

    public ListResponse<Card> listCards(String customerId) {
        return this.listCards(new CardListRequest().customerId(customerId));
    }

    public ListResponse<Card> listCards(CardListRequest listCards) {
        return this.list(String.format(CARDS_PATH, listCards.getCustomerId()), listCards, Card.class);
    }

    public PaymentMethod createPaymentMethod(PaymentMethodRequest request) {
        return this.post(PAYMENT_METHOD_PATH, request, PaymentMethod.class);
    }

    public PaymentMethod createPaymentMethod(PaymentMethodRequest request, RequestOptions requestOptions) {
        return this.post(PAYMENT_METHOD_PATH, request, requestOptions, PaymentMethod.class);
    }

    public PaymentMethod retrievePaymentMethod(String paymentMethodId) {
        return this.get("/payment-methods/" + paymentMethodId, PaymentMethod.class);
    }

    public ListResponse<PaymentMethod> listPaymentMethods(PaymentMethodListRequest listRequest) {
        return this.list(PAYMENT_METHOD_PATH, listRequest, PaymentMethod.class);
    }

    public DeleteResponse deletePaymentMethod(String paymentMethodId) {
        return this.delete("/payment-methods/" + paymentMethodId, DeleteResponse.class);
    }

    public Subscription createSubscription(SubscriptionRequest request) {
        return this.post(SUBSCRIPTIONS_PATH, request, Subscription.class);
    }

    public Subscription createSubscription(SubscriptionRequest request, RequestOptions requestOptions) {
        return this.post(SUBSCRIPTIONS_PATH, request, requestOptions, Subscription.class);
    }

    public Subscription retrieveSubscription(String subscriptionId) {
        return this.get("/subscriptions/" + subscriptionId, Subscription.class);
    }

    public Subscription updateSubscription(SubscriptionUpdateRequest request) {
        return this.post("/subscriptions/" + request.getSubscriptionId(), request, Subscription.class);
    }

    public Subscription updateSubscription(SubscriptionUpdateRequest request, RequestOptions requestOptions) {
        return this.post("/subscriptions/" + request.getSubscriptionId(), request, requestOptions, Subscription.class);
    }

    public Subscription cancelSubscription(SubscriptionCancelRequest request) {
        return this.delete("/subscriptions/" + request.getSubscriptionId(), request, Subscription.class);
    }

    public ListResponse<Subscription> listSubscriptions(String customerId) {
        return this.listSubscriptions(new SubscriptionListRequest().customerId(customerId));
    }

    public ListResponse<Subscription> listSubscriptions(SubscriptionListRequest request) {
        return this.list(SUBSCRIPTIONS_PATH, request, Subscription.class);
    }

    public Plan createPlan(PlanRequest request) {
        return this.post(PLANS_PATH, request, Plan.class);
    }

    public Plan createPlan(PlanRequest request, RequestOptions requestOptions) {
        return this.post(PLANS_PATH, request, requestOptions, Plan.class);
    }

    public Plan retrievePlan(String planId) {
        return this.get("/plans/" + planId, Plan.class);
    }

    public Plan updatePlan(PlanUpdateRequest request) {
        return this.post("/plans/" + request.getPlanId(), request, Plan.class);
    }

    public Plan updatePlan(PlanUpdateRequest request, RequestOptions requestOptions) {
        return this.post("/plans/" + request.getPlanId(), request, requestOptions, Plan.class);
    }

    public DeleteResponse deletePlan(String planId) {
        return this.delete("/plans/" + planId, DeleteResponse.class);
    }

    public ListResponse<Plan> listPlans() {
        return this.list(PLANS_PATH, Plan.class);
    }

    public ListResponse<Plan> listPlans(PlanListRequest request) {
        return this.list(PLANS_PATH, request, Plan.class);
    }

    public Event retrieveEvent(String eventId) {
        return this.get("/events/" + eventId, Event.class);
    }

    public ListResponse<Event> listEvents() {
        return this.list(EVENTS_PATH, Event.class);
    }

    public ListResponse<Event> listEvents(EventListRequest listEvents) {
        return this.list(EVENTS_PATH, listEvents, Event.class);
    }

    public Token createToken(TokenRequest request) {
        return this.post(TOKENS_PATH, request, Token.class);
    }

    public Token createToken(TokenRequest request, RequestOptions requestOptions) {
        return this.post(TOKENS_PATH, request, requestOptions, Token.class);
    }

    public Token retrieveToken(String tokenId) {
        return this.get("/tokens/" + tokenId, Token.class);
    }

    public BlacklistRule createBlacklistRule(BlacklistRuleRequest request) {
        return this.post(BLACKLIST_RULE_PATH, request, BlacklistRule.class);
    }

    public BlacklistRule createBlacklistRule(BlacklistRuleRequest request, RequestOptions requestOptions) {
        return this.post(BLACKLIST_RULE_PATH, request, requestOptions, BlacklistRule.class);
    }

    public BlacklistRule retrieveBlacklistRule(String blacklistRuleId) {
        return this.get("/blacklist/" + blacklistRuleId, BlacklistRule.class);
    }

    public DeleteResponse deleteBlacklistRule(String blacklistRuleId) {
        return this.delete("/blacklist/" + blacklistRuleId, DeleteResponse.class);
    }

    public ListResponse<BlacklistRule> listBlacklistRules() {
        return this.list(BLACKLIST_RULE_PATH, BlacklistRule.class);
    }

    public ListResponse<BlacklistRule> listBlacklistRules(BlacklistRuleListRequest request) {
        return this.list(BLACKLIST_RULE_PATH, request, BlacklistRule.class);
    }

    public Credit createCredit(CreditRequest request) {
        return this.post(CREDIT_PATH, request, Credit.class);
    }

    public Credit createCredit(CreditRequest request, RequestOptions requestOptions) {
        return this.post(CREDIT_PATH, request, requestOptions, Credit.class);
    }

    public Credit retrieveCredit(String creditId) {
        return this.get("/credits/" + creditId, Credit.class);
    }

    public Credit updateCredit(CreditUpdateRequest credit) {
        return this.post("/credits/" + credit.getCreditId(), credit, Credit.class);
    }

    public Credit updateCredit(CreditUpdateRequest credit, RequestOptions requestOptions) {
        return this.post("/credits/" + credit.getCreditId(), credit, requestOptions, Credit.class);
    }

    public ListResponse<Credit> listCredits() {
        return this.list(CREDIT_PATH, Credit.class);
    }

    public ListResponse<Credit> listCredits(CreditListRequest request) {
        return this.list(CREDIT_PATH, request, Credit.class);
    }

    public String signCheckoutRequest(CheckoutRequest checkoutRequest) {
        String data = this.objectSerializer.serialize(checkoutRequest);
        try {
            String algorithm = "HmacSHA256";
            Mac hmac = Mac.getInstance(algorithm);
            hmac.init(new SecretKeySpec(this.gatewayClient.getSecretKey().getBytes(StandardCharsets.UTF_8), algorithm));
            String signature = Hex.encodeHexString((byte[])hmac.doFinal(data.getBytes(StandardCharsets.UTF_8)));
            return Base64.encodeBase64String((byte[])(signature + "|" + data).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            throw new SignException(ex);
        }
    }

    public FileUpload createFileUpload(File file, FileUploadPurpose purpose) {
        HashMap<String, File> files = new HashMap<String, File>();
        files.put("file", file);
        HashMap<String, String> form = new HashMap<String, String>();
        form.put("purpose", purpose.getValue());
        return this.uploadsMultipart(FILES_PATH, files, form, FileUpload.class);
    }

    public FileUpload retrieveFileUpload(String id) {
        return this.uploadsGet("/files/" + id, FileUpload.class);
    }

    public ListResponse<FileUpload> listFileUploads() {
        return this.uploadslist(FILES_PATH, null, FileUpload.class);
    }

    public ListResponse<FileUpload> listFileUploads(FileUploadListRequest request) {
        return this.uploadslist(FILES_PATH, request, FileUpload.class);
    }

    public Dispute retrieveDispute(String id) {
        return this.get("/disputes/" + id, Dispute.class);
    }

    public Dispute updateDispute(DisputeUpdateRequest request) {
        return this.post("/disputes/" + request.getDisputeId(), request, Dispute.class);
    }

    public Dispute updateDispute(DisputeUpdateRequest request, RequestOptions requestOptions) {
        return this.post("/disputes/" + request.getDisputeId(), request, requestOptions, Dispute.class);
    }

    public Dispute closeDispute(String id) {
        return this.post("/disputes/" + id + "/close", null, Dispute.class);
    }

    public ListResponse<Dispute> listDisputes() {
        return this.list(DISPUTES_PATH, null, Dispute.class);
    }

    public ListResponse<Dispute> listDisputes(DisputeListRequest request) {
        return this.list(DISPUTES_PATH, request, Dispute.class);
    }

    public ListResponse<FraudWarning> listFraudWarnings() {
        return this.list(FRAUD_WARNING_PATH, FraudWarning.class);
    }

    public ListResponse<FraudWarning> listFraudWarnings(FraudWarningListRequest request) {
        return this.list(FRAUD_WARNING_PATH, request, FraudWarning.class);
    }

    public FraudWarning retrieveFraudWarning(String id) {
        return this.get("/fraud-warnings/" + id, FraudWarning.class);
    }

    public Refund retrieveRefund(String refundId) {
        return this.get("/refunds/" + refundId, Refund.class);
    }

    public Refund createRefund(RefundRequest request) {
        return this.post(REFUND_PATH, request, Refund.class);
    }

    public Refund createRefund(RefundRequest request, RequestOptions requestOptions) {
        return this.post(REFUND_PATH, request, requestOptions, Refund.class);
    }

    public Refund updateRefund(RefundUpdateRequest request) {
        return this.post("/refunds/" + request.getRefundId(), request, Refund.class);
    }

    public Refund updateRefund(RefundUpdateRequest request, RequestOptions requestOptions) {
        return this.post("/refunds/" + request.getRefundId(), request, requestOptions, Refund.class);
    }

    public ListResponse<Refund> listRefunds(String chargeId) {
        RefundListRequest request = new RefundListRequest();
        request.chargeId(chargeId);
        return this.listRefunds(request);
    }

    public ListResponse<Refund> listRefunds(RefundListRequest request) {
        return this.list(REFUND_PATH, request, Refund.class);
    }

    public Payout retrievePayout(String id) {
        return this.get("/payouts/" + id, Payout.class);
    }

    public Payout createPayout() {
        return this.post("/payouts", null, Payout.class);
    }

    public ListResponse<Payout> listPayouts() {
        return this.list("/payouts", Payout.class);
    }

    public ListResponse<Payout> listPayouts(PayoutListRequest request) {
        return this.list("/payouts", request, Payout.class);
    }

    public ListResponse<PayoutTransaction> listPayoutTransactions(String payoutId) {
        PayoutTransactionListRequest request = new PayoutTransactionListRequest();
        request.payout(payoutId);
        return this.list("/payout-transactions", request, PayoutTransaction.class);
    }

    public ListResponse<PayoutTransaction> listPayoutTransactions(PayoutTransactionListRequest request) {
        return this.list("/payout-transactions", request, PayoutTransaction.class);
    }

    @Override
    public void close() throws IOException {
        this.gatewayClient.close();
        this.gatewayUploadsClient.close();
    }

    protected <T> T get(String path, Class<T> responseClass) {
        return this.gatewayClient.get(path, responseClass);
    }

    protected <T> T get(String path, Class<T> responseClass, Expand expand) {
        return this.gatewayClient.get(path, responseClass, expand);
    }

    protected <T> T get(String path, Class<T> responseClass, RequestOptions options, Expand expand) {
        return this.gatewayClient.get(path, responseClass, expand, options);
    }

    protected <T> T uploadsGet(String path, Class<T> responseClass) {
        return this.gatewayUploadsClient.get(path, responseClass);
    }

    protected <T> T post(String path, Object request, Class<T> responseClass) {
        return this.gatewayClient.post(path, request, responseClass);
    }

    protected <T> T post(String path, Object request, RequestOptions options, Class<T> responseClass) {
        return this.gatewayClient.post(path, request, options, responseClass);
    }

    protected <T> T uploadsMultipart(String path, Map<String, File> files, Map<String, String> form, Class<T> responseClass) {
        return this.gatewayUploadsClient.multipart(path, files, form, responseClass);
    }

    protected <T> ListResponse<T> list(String path, Class<T> elementClass) {
        return this.gatewayClient.list(path, elementClass);
    }

    protected <T> ListResponse<T> list(String path, Object request, Class<T> elementClass) {
        return this.gatewayClient.list(path, request, elementClass);
    }

    protected <T> ListResponse<T> list(String path, Object request, RequestOptions options, Class<T> elementClass) {
        return this.gatewayClient.list(path, request, options, elementClass);
    }

    protected <T> ListResponse<T> uploadslist(String path, Object request, Class<T> elementClass) {
        return this.gatewayUploadsClient.list(path, request, elementClass);
    }

    protected <T> T delete(String path, Class<T> responseClass) {
        return this.gatewayClient.delete(path, responseClass);
    }

    protected <T> T delete(String path, Object request, Class<T> responseClass) {
        return this.gatewayClient.delete(path, request, responseClass);
    }

    public void setSecretKey(String secretKey) {
        this.gatewayClient.setSecretKey(secretKey);
        this.gatewayUploadsClient.setSecretKey(secretKey);
    }

    public void setConnection(Connection connection) {
        this.gatewayClient.setConnection(connection);
        this.gatewayUploadsClient.setConnection(connection);
    }

    public void setEndpoint(String endpoint) {
        this.gatewayClient.setEndpoint(endpoint);
    }

    public void setUploadsEndpoint(String uploadsEndpoint) {
        this.gatewayUploadsClient.setEndpoint(uploadsEndpoint);
    }

    public void setMerchantId(String merchantId) {
        this.gatewayClient.setMerchantId(merchantId);
        this.gatewayUploadsClient.setMerchantId(merchantId);
    }

    public void setHeadersFactory(Shift4GatewayHeadersFactory headersFactory) {
        this.gatewayClient.setHeadersFactory(headersFactory);
        this.gatewayUploadsClient.setHeadersFactory(headersFactory);
    }
}

