/*
 * Decompiled with CFR 0.152.
 */
package com.shift4.request;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.shift4.enums.ChargeType;
import com.shift4.request.BillingRequest;
import com.shift4.request.CardRequest;
import com.shift4.request.ChargeFlowRequest;
import com.shift4.request.PaymentMethodRequest;
import com.shift4.request.ShippingRequest;
import com.shift4.request.ThreeDSecureRequest;
import com.shift4.response.Customer;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChargeRequest {
    private Integer amount;
    private String currency;
    private String description;
    private String customerId;
    private CardRequest card;
    private PaymentMethodRequest paymentMethod;
    private ChargeFlowRequest flow;
    private ChargeType type;
    private Boolean captured;
    private ShippingRequest shipping;
    private BillingRequest billing;
    private ThreeDSecureRequest threeDSecure;
    private String merchantAccountId;
    private Map<String, String> metadata;
    @JsonIgnore
    private final Map<String, Object> other = new HashMap<String, Object>();

    public ChargeRequest() {
    }

    public ChargeRequest(Integer amount, String currency) {
        this.amount(amount).currency(currency);
    }

    public Integer getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public CardRequest getCard() {
        return this.card;
    }

    public PaymentMethodRequest getPaymentMethod() {
        return this.paymentMethod;
    }

    public ChargeFlowRequest getFlow() {
        return this.flow;
    }

    public ChargeType getType() {
        return this.type;
    }

    public Boolean getCaptured() {
        return this.captured;
    }

    public BillingRequest getBilling() {
        return this.billing;
    }

    public ShippingRequest getShipping() {
        return this.shipping;
    }

    public ThreeDSecureRequest getThreeDSecure() {
        return this.threeDSecure;
    }

    public String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ChargeRequest amount(Integer amount) {
        this.amount = amount;
        return this;
    }

    public ChargeRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    public ChargeRequest description(String description) {
        this.description = description;
        return this;
    }

    public ChargeRequest customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    public ChargeRequest customer(Customer customer) {
        return this.customerId(customer.getId());
    }

    public ChargeRequest card(CardRequest card) {
        this.card = card;
        return this;
    }

    public ChargeRequest paymentMethod(PaymentMethodRequest paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    public ChargeRequest flow(ChargeFlowRequest flow) {
        this.flow = flow;
        return this;
    }

    public ChargeRequest type(ChargeType type) {
        this.type = type;
        return this;
    }

    public ChargeRequest captured(Boolean captured) {
        this.captured = captured;
        return this;
    }

    public ChargeRequest shipping(ShippingRequest shipping) {
        this.shipping = shipping;
        return this;
    }

    public ChargeRequest billing(BillingRequest billing) {
        this.billing = billing;
        return this;
    }

    public ChargeRequest threeDSecure(ThreeDSecureRequest threeDSecure) {
        this.threeDSecure = threeDSecure;
        return this;
    }

    public ChargeRequest merchantAccountId(String merchantAccountId) {
        this.merchantAccountId = merchantAccountId;
        return this;
    }

    public ChargeRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @JsonAnyGetter
    private Map<String, Object> getOtherMap() {
        return this.other;
    }

    @JsonAnySetter
    public ChargeRequest set(String name, Object value) {
        this.other.put(name, value);
        return this;
    }
}

