/*
 * Decompiled with CFR 0.152.
 */
package com.shift4.response;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.shift4.enums.ChargeStatus;
import com.shift4.enums.ChargeType;
import com.shift4.enums.ErrorCode;
import com.shift4.response.AvsCheck;
import com.shift4.response.Billing;
import com.shift4.response.Card;
import com.shift4.response.ChargeFlow;
import com.shift4.response.Dispute;
import com.shift4.response.FraudDetails;
import com.shift4.response.PaymentMethod;
import com.shift4.response.Refund;
import com.shift4.response.Shipping;
import com.shift4.response.ThreeDSecureInfo;
import com.shift4.util.Shift4Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Charge {
    private String id;
    private String clientObjectId;
    private Long created;
    private Integer amount;
    private Integer amountRefunded;
    private String currency;
    private String description;
    private ChargeStatus status;
    private ChargeType type;
    private Card card;
    private PaymentMethod paymentMethod;
    private ChargeFlow flow;
    private String customerId;
    private String subscriptionId;
    private Boolean captured;
    private Boolean refunded;
    private List<Refund> refunds;
    private Boolean disputed;
    private FraudDetails fraudDetails;
    private Shipping shipping;
    private Billing billing;
    private ThreeDSecureInfo threeDSecureInfo;
    private AvsCheck avsCheck;
    private Dispute dispute;
    private String merchantAccountId;
    private Map<String, String> metadata;
    private String failureCode;
    private String failureIssuerDeclineCode;
    private String failureMessage;
    @JsonIgnore
    private final Map<String, Object> other = new HashMap<String, Object>();

    public String getId() {
        return this.id;
    }

    public String getClientObjectId() {
        return this.clientObjectId;
    }

    public Long getCreated() {
        return this.created;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public Integer getAmountRefunded() {
        return this.amountRefunded;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getDescription() {
        return this.description;
    }

    public ChargeStatus getStatus() {
        return this.status;
    }

    public ChargeType getType() {
        return this.type;
    }

    public Card getCard() {
        return this.card;
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public ChargeFlow getFlow() {
        return this.flow;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public Boolean getCaptured() {
        return this.captured;
    }

    public Boolean getRefunded() {
        return this.refunded;
    }

    public List<Refund> getRefunds() {
        return this.refunds;
    }

    public Boolean getDisputed() {
        return this.disputed;
    }

    public FraudDetails getFraudDetails() {
        return this.fraudDetails;
    }

    public Shipping getShipping() {
        return this.shipping;
    }

    public Billing getBilling() {
        return this.billing;
    }

    public ThreeDSecureInfo getThreeDSecureInfo() {
        return this.threeDSecureInfo;
    }

    public AvsCheck getAvsCheck() {
        return this.avsCheck;
    }

    public Dispute getDispute() {
        return this.dispute;
    }

    public String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ErrorCode getFailureCode() {
        return ErrorCode.fromValue(this.failureCode);
    }

    public String getFailureCodeAsString() {
        return this.failureCode;
    }

    public String getFailureIssuerDeclineCode() {
        return this.failureIssuerDeclineCode;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public String get(String name) {
        if ("merchantAccountId".equals(name)) {
            return this.merchantAccountId;
        }
        return Shift4Utils.toStringNullSafe(this.other.get(name));
    }

    @JsonAnySetter
    private void set(String name, Object value) {
        this.other.put(name, value);
    }
}

