/*
 * Decompiled with CFR 0.152.
 */
package com.sigopt.net;

import com.sigopt.net.MapHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

class HeadersBuilder {
    HeadersBuilder() {
    }

    public static Map<String, String> build(Map<String, String> headers) {
        return HeadersBuilder.build(headers, null, null);
    }

    public static Map<String, String> build(Map<String, String> headers, String apiKey) {
        return HeadersBuilder.build(headers, apiKey, null);
    }

    public static Map<String, String> build(Map<String, String> headers, String apiKey, String authKey) {
        Map<Object, Object> ret = new HashMap();
        ret = MapHelper.merge(ret, HeadersBuilder.defaultHeaders());
        if (authKey != null && !authKey.isEmpty()) {
            ret = MapHelper.merge(ret, HeadersBuilder.customAuthHeader(authKey, apiKey));
        } else if (apiKey != null && !apiKey.isEmpty()) {
            ret = MapHelper.merge(ret, HeadersBuilder.basicAuthHeader(apiKey));
        }
        if (headers != null) {
            ret.putAll(headers);
        }
        return ret;
    }

    public static Map<String, String> defaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        String userAgent = "Sigopt/v1 JavaBindings/4.6.0";
        headers.put("User-Agent", userAgent);
        return headers;
    }

    public static Map<String, String> customAuthHeader(String authKey, String apiKey) {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put(authKey, apiKey);
        return ret;
    }

    public static Map<String, String> basicAuthHeader(String apiKey) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (apiKey != null) {
            byte[] apiKeyBytes = String.format("%s:", apiKey).getBytes();
            String base64Key = new String(Base64.encodeBase64((byte[])apiKeyBytes));
            ret.put("Authorization", "Basic " + base64Key);
        }
        return ret;
    }
}

