/*
 * Decompiled with CFR 0.152.
 */
package com.sigopt.model;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class APIObject {
    Map<String, Object> model = new HashMap<String, Object>();
    private static final Gson GSON = new GsonBuilder().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private static final Gson PRETTY_PRINT_GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    protected final Object mapGet(String key) {
        return this.model.get(key);
    }

    private Object adaptForStorage(Object value) {
        if (value instanceof APIObject) {
            return ((APIObject)value).model;
        }
        if (value instanceof Collection) {
            ArrayList<Object> ret = new ArrayList<Object>();
            for (Object v : (Collection)value) {
                ret.add(this.adaptForStorage(v));
            }
            return ret;
        }
        if (value instanceof Map) {
            HashMap ret = new HashMap();
            Map valueAsMap = (Map)value;
            for (Object key : valueAsMap.keySet()) {
                ret.put(key, this.adaptForStorage(valueAsMap.get(key)));
            }
            return ret;
        }
        return value;
    }

    final <T> void set(String key, T value) {
        this.model.put(key, this.adaptForStorage(value));
    }

    final void setAll(Map<String, Object> map) {
        this.model.clear();
        if (map != null) {
            this.model.putAll(map);
        }
    }

    public static String toJson(Object value) {
        if (value instanceof APIObject) {
            return GSON.toJson(((APIObject)value).model);
        }
        return GSON.toJson(value);
    }

    public String toJson() {
        return APIObject.toJson(this);
    }

    public static Map<String, Object> fromJson(String json, Type t) {
        return (Map)GSON.fromJson(json, t);
    }

    public String toString() {
        return String.format("<%s@%s> Attributes: %s", this.getClass().getName(), System.identityHashCode(this), this.toJson());
    }

    public boolean equals(Object other) {
        return other != null && this.getClass().equals(other.getClass()) && this.model.equals(((APIObject)other).model);
    }

    public int hashCode() {
        return this.model.hashCode();
    }

    public static boolean equals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }
}

