/*
 * Decompiled with CFR 0.152.
 */
package com.sigopt.model;

import com.sigopt.model.APIObjectBuilder;
import com.sigopt.model.Assignments;
import com.sigopt.model.Metadata;
import com.sigopt.model.MetricEvaluation;
import com.sigopt.model.StructObject;
import com.sigopt.model.Task;
import com.sigopt.model.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Observation
extends StructObject {
    public Observation() {
    }

    public Observation(String id) {
        this.set("id", id);
    }

    public Boolean isFailed() {
        return (Boolean)this.get("failed");
    }

    public Double getValue() {
        return (Double)this.get("value");
    }

    public Double getValueStddev() {
        return (Double)this.get("value_stddev");
    }

    public List<MetricEvaluation> getValues() {
        return Utils.mergeIntoList(new ArrayList(), this.get("values"), MetricEvaluation.class);
    }

    public Integer getCreated() {
        return Utils.asInteger(this.get("created"));
    }

    public Assignments getAssignments() {
        return Utils.mergeInto(new Assignments(), this.get("assignments"));
    }

    public Metadata getMetadata() {
        return Utils.mergeInto(new Metadata(), this.get("metadata"));
    }

    public String getExperiment() {
        return (String)this.get("experiment");
    }

    public String getId() {
        return (String)this.get("id");
    }

    public String getSuggestion() {
        return (String)this.get("suggestion");
    }

    public Task getTask() {
        return Utils.mergeInto(new Task(), this.get("task"));
    }

    public static class Builder
    extends APIObjectBuilder<Observation> {
        public Builder() {
            this.obj = new Observation();
        }

        public Builder failed(boolean failed) {
            ((Observation)this.obj).set("failed", failed);
            return this;
        }

        public Builder value(double value) {
            ((Observation)this.obj).set("value", value);
            return this;
        }

        public Builder valueStddev(double valueStddev) {
            ((Observation)this.obj).set("value_stddev", valueStddev);
            return this;
        }

        public Builder values(List<MetricEvaluation> values) {
            ((Observation)this.obj).set("values", values);
            return this;
        }

        public Builder created(int created) {
            ((Observation)this.obj).set("created", created);
            return this;
        }

        public Builder assignments(Map<String, Object> assignments) {
            ((Observation)this.obj).set("assignments", assignments);
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            ((Observation)this.obj).set("metadata", metadata);
            return this;
        }

        public Builder experiment(String experiment) {
            ((Observation)this.obj).set("experiment", experiment);
            return this;
        }

        public Builder id(String id) {
            ((Observation)this.obj).set("id", id);
            return this;
        }

        public Builder suggestion(String suggestion) {
            ((Observation)this.obj).set("suggestion", suggestion);
            return this;
        }

        public Builder task(Task task) {
            ((Observation)this.obj).set("task", task);
            return this;
        }
    }
}

