/*
 * Decompiled with CFR 0.152.
 */
package com.sigopt.model;

import com.sigopt.exception.SigoptException;
import com.sigopt.model.APIObject;
import com.sigopt.model.PaginationIterable;
import com.sigopt.model.Paging;
import com.sigopt.model.StructObject;
import com.sigopt.model.Utils;
import com.sigopt.net.APIMethodCaller;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Pagination<T extends APIObject>
extends StructObject {
    Class<T> klass;
    APIMethodCaller<Pagination<T>> apiMethodCaller;

    public Pagination(Class<T> klass) {
        this.klass = klass;
        this.apiMethodCaller = null;
    }

    public void bind(APIMethodCaller<Pagination<T>> apiMethodCaller) {
        this.apiMethodCaller = apiMethodCaller;
    }

    private boolean useBefore() {
        if (this.apiMethodCaller == null) {
            return true;
        }
        Map<String, Object> params = this.apiMethodCaller.getParams();
        return params.containsKey("before") || !params.containsKey("after");
    }

    boolean hasNext() {
        if (this.useBefore()) {
            return this.getPaging().getBefore() != null;
        }
        return this.getPaging().getAfter() != null;
    }

    Pagination<T> nextPagination() throws SigoptException {
        if (this.useBefore()) {
            this.apiMethodCaller.addParam("before", this.getPaging().getBefore());
            this.apiMethodCaller.removeParam("after");
        } else {
            this.apiMethodCaller.addParam("after", this.getPaging().getAfter());
            this.apiMethodCaller.removeParam("before");
        }
        Pagination<T> ret = this.apiMethodCaller.call();
        ret.bind(this.apiMethodCaller);
        return ret;
    }

    public Integer getCount() {
        return Utils.asInteger(this.get("count"));
    }

    public List<T> getData() {
        return Utils.mergeIntoList(new ArrayList(), this.get("data"), this.klass);
    }

    public Paging getPaging() {
        return Utils.mergeInto(new Paging(), this.get("paging"));
    }

    public Iterable<T> iteratePages() {
        return new PaginationIterable(this);
    }
}

