/*
 * Decompiled with CFR 0.152.
 */
package com.sigopt.model;

import com.sigopt.exception.SigoptException;
import com.sigopt.model.APIObject;
import com.sigopt.model.Pagination;
import java.util.Iterator;
import java.util.NoSuchElementException;

class PaginationIterator<T extends APIObject>
implements Iterator {
    Pagination<T> pagination;
    Iterator<T> page;
    T nextItem;

    public PaginationIterator(Pagination<T> pagination) {
        this.pagination = pagination;
        this.page = this.pagination.getData().iterator();
        this.advance();
    }

    private void advance() {
        try {
            while (!this.page.hasNext() && this.pagination.hasNext()) {
                this.pagination = this.pagination.nextPagination();
                this.page = this.pagination.getData().iterator();
            }
            this.nextItem = this.page.hasNext() ? (APIObject)this.page.next() : null;
        }
        catch (SigoptException e) {
            throw new RuntimeException("Failed to fetch next data page", e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextItem != null;
    }

    public T next() {
        T ret = this.nextItem;
        if (ret == null) {
            throw new NoSuchElementException();
        }
        this.advance();
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

