/*
 * Decompiled with CFR 0.152.
 */
package com.sigopt.net;

import com.sigopt.net.MapHelper;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PathBuilder {
    PathBuilder() {
    }

    public static String build(String path, Map<String, String> params) {
        params = MapHelper.ensure(params);
        Pattern r = Pattern.compile(":([^\\/]*)");
        Matcher m = r.matcher(path);
        while (m.find()) {
            String match = m.group(1);
            int start = m.start();
            int end = start + match.length() + 1;
            path = path.substring(0, start) + PathBuilder.determineValue(match, params) + path.substring(end, path.length());
            m = r.matcher(path);
        }
        return path;
    }

    public static String determineValue(String match, Map<String, String> params) {
        String param = params.get(match);
        if (param == null) {
            throw new NullPointerException("Missing required parameter: " + match);
        }
        return param;
    }
}

