/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.simiacryptus.ref.wrappers.RefSystem;

public class FastRandom {
    public static final FastRandom INSTANCE = new FastRandom();
    private final long t;
    private long x;
    private long y;
    private long z;

    public FastRandom() {
        this(RefSystem.nanoTime());
    }

    public FastRandom(long seed) {
        this.t = seed >>> 24;
        this.x = seed;
        this.y = seed >>> 8;
        this.z = seed >>> 16;
    }

    public static long xorshift(long x) {
        x ^= x << 16;
        x ^= x >> 5;
        x ^= x << 1;
        return x;
    }

    public double random() {
        double y;
        long z = this.next();
        int exponentMag = 4;
        double resolution = 1.0E8;
        double x = (double)(z / 2L) % resolution / resolution;
        for (y = (double)(z % (long)exponentMag - (long)(exponentMag / 2)); y > 1.0; y -= 1.0) {
            x = 2.0;
        }
        while (y < -1.0) {
            y += 1.0;
            x /= 2.0;
        }
        return x;
    }

    public long next() {
        long x = FastRandom.xorshift(this.x);
        this.x = this.y;
        this.y = this.z;
        this.z = this.x ^ x ^ this.y;
        return this.z;
    }
}

