/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.simiacryptus.ref.lang.RefUtil;
import com.simiacryptus.ref.wrappers.RefArrays;
import com.simiacryptus.ref.wrappers.RefString;
import com.simiacryptus.ref.wrappers.RefStringBuilder;
import com.simiacryptus.ref.wrappers.RefSystem;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class LOG {
    private static final long startTime = RefSystem.nanoTime();

    public static void d(@Nonnull String msg, Object ... args) {
        LOG.preprocessArgs(args);
        LOG.log(msg, args);
    }

    public static void d(@Nonnull Throwable e, CharSequence msg, Object ... args) {
        LOG.d(msg + "\n  " + LOG.toString(e).replace("\n", "\n  "), args);
    }

    public static String toString(@Nonnull Throwable e) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PrintStream s = new PrintStream(out);){
            e.printStackTrace(s);
        }
        return out.toString();
    }

    private static void log(@Nonnull String msg, Object[] args) {
        String formatted = RefString.format((String)msg, (Object[])args);
        StackTraceElement caller = (StackTraceElement)RefUtil.get(Arrays.stream(Thread.currentThread().getStackTrace()).filter(stack -> {
            Class<?> clazz;
            try {
                clazz = Class.forName(stack.getClassName());
            }
            catch (Exception e) {
                return true;
            }
            if (clazz == Thread.class) {
                return false;
            }
            return clazz != LOG.class;
        }).findFirst());
        double time = (double)(RefSystem.nanoTime() - startTime) / 1.0E9;
        String line = RefString.format((String)"[%.5f] (%s:%s) %s", (Object[])new Object[]{time, caller.getFileName(), caller.getLineNumber(), formatted.replaceAll("\n", "\n\t")});
        System.out.println(line);
    }

    private static void preprocessArgs(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Class<?> c;
            if (null == args[i] || !(c = args[i].getClass()).isArray()) continue;
            args[i] = args[i] instanceof double[] ? LOG.toString((double[])args[i]) : (args[i] instanceof int[] ? RefArrays.toString((int[])((int[])args[i])) : (args[i] instanceof long[] ? RefArrays.toString((long[])((long[])args[i])) : (args[i] instanceof byte[] ? RefArrays.toString((byte[])((byte[])args[i])) : RefArrays.toString((Object[])((Object[])args[i])))));
        }
    }

    private static @Nonnull CharSequence toString(@Nonnull double[] point) {
        RefStringBuilder sb = new RefStringBuilder();
        for (double v : point) {
            if (0 < sb.length()) {
                sb.append((CharSequence)", ");
            }
            sb.append((CharSequence)RefString.format((String)"%.3f", (Object[])new Object[]{v}));
        }
        return "[" + sb + "]";
    }

    public static enum Severity {
        Debug;

    }
}

