/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.simiacryptus.util.Util;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ClassUtils;

public class ReflectionUtil {
    public static <T> @Nullable T getField(@Nonnull Object obj, String name) {
        Field value = Arrays.stream(obj.getClass().getDeclaredFields()).filter(x -> x.getName().equals(name)).findFirst().orElse(null);
        if (value != null) {
            value.setAccessible(true);
            try {
                return (T)value.get(obj);
            }
            catch (IllegalAccessException e) {
                throw Util.throwException(e);
            }
        }
        return null;
    }

    public static <T> @Nonnull T invokeMethod(@Nonnull Object obj, String name, Object ... args) {
        Method value = Arrays.stream(obj.getClass().getDeclaredMethods()).filter(x -> x.getName().equals(name)).filter(x -> {
            Class<?>[] parameterTypes = x.getParameterTypes();
            if (parameterTypes.length != args.length) {
                return false;
            }
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (ClassUtils.isAssignable(parameterTypes[i], args[i].getClass())) continue;
                return false;
            }
            return true;
        }).findFirst().orElse(null);
        if (value != null) {
            value.setAccessible(true);
            try {
                return (T)value.invoke(obj, args);
            }
            catch (IllegalAccessException e) {
                throw Util.throwException(e);
            }
            catch (InvocationTargetException e) {
                throw Util.throwException(e);
            }
        }
        throw new RuntimeException(String.format("Method %s.%s(%s) not found", obj.getClass(), name, Arrays.stream(args).map(x -> x.getClass().getSimpleName()).reduce((a, b) -> a + ", " + b).get()));
    }

    public static @Nonnull Field getField(@Nonnull Class<?> nodeClass, String name) {
        Field[] fields = nodeClass.getDeclaredFields();
        Optional<Field> parent = Arrays.stream(fields).filter(x -> x.getName().equals(name)).findFirst();
        if (!parent.isPresent()) {
            Class<?> superclass = nodeClass.getSuperclass();
            if (superclass != null) {
                return ReflectionUtil.getField(superclass, name);
            }
            throw new AssertionError((Object)String.format("Cannot find field %s", name));
        }
        Field field = parent.get();
        field.setAccessible(true);
        return field;
    }

    public static <T> @Nonnull T setField(@Nonnull T astNode, String name, Object value) {
        try {
            ReflectionUtil.getField(astNode.getClass(), name).set(astNode, value);
            return astNode;
        }
        catch (IllegalAccessException e) {
            throw Util.throwException(e);
        }
    }
}

