/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.binary;

import com.simiacryptus.ref.wrappers.RefArrays;
import com.simiacryptus.ref.wrappers.RefString;
import com.simiacryptus.util.binary.BitOutputStream;
import com.simiacryptus.util.binary.Bits;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;

public class BitInputStream {
    private final InputStream inner;
    private @Nonnull Bits remainder = new Bits(0L);

    public BitInputStream(InputStream inner) {
        this.inner = inner;
    }

    public static @Nonnull BitInputStream toBitStream(@Nonnull byte[] data) {
        return new BitInputStream(new ByteArrayInputStream(data));
    }

    public void close() throws IOException {
        this.inner.close();
    }

    public int availible() throws IOException {
        return this.remainder.bitLength + 8 * this.inner.available();
    }

    public <T extends Enum<T>> void expect(@Nonnull Enum<T> expect) throws IOException {
        Bits checkBits = this.read(8);
        long expectedLong = expect.ordinal();
        if (checkBits.toLong() != expectedLong) {
            Bits expectedBits = new Bits(expectedLong, 8);
            throw new IOException(RefString.format((String)"Check for %s failed: %s != %s", (Object[])new Object[]{expect, checkBits, expectedBits}));
        }
    }

    public void expect(@Nonnull Bits bits) throws IOException {
        int size = Math.min(this.availible(), bits.bitLength);
        Bits read = this.read(size);
        if (!bits.range(0, size).equals(read)) {
            throw new RuntimeException(RefString.format((String)"%s is not expected %s", (Object[])new Object[]{read, bits}));
        }
    }

    public @Nonnull Bits read(int bits) throws IOException {
        int additionalBitsNeeded = bits - this.remainder.bitLength;
        int additionalBytesNeeded = (int)Math.ceil((double)additionalBitsNeeded / 8.0);
        if (additionalBytesNeeded > 0) {
            this.readAhead(additionalBytesNeeded);
        }
        Bits readBits = this.remainder.range(0, bits);
        this.remainder = this.remainder.range(bits);
        return readBits;
    }

    public @Nonnull Bits peek(int bits) throws IOException {
        int additionalBitsNeeded = bits - this.remainder.bitLength;
        int additionalBytesNeeded = (int)Math.ceil((double)additionalBitsNeeded / 8.0);
        if (additionalBytesNeeded > 0) {
            this.readAhead(additionalBytesNeeded);
        }
        return this.remainder.range(0, Math.min(bits, this.remainder.bitLength));
    }

    public @Nonnull Bits readAhead() throws IOException {
        return this.readAhead(1);
    }

    public @Nonnull Bits readAhead(int bytes) throws IOException {
        assert (0 < bytes);
        byte[] buffer = new byte[bytes];
        int bytesRead = this.inner.read(buffer);
        if (bytesRead > 0) {
            this.remainder = this.remainder.concatenate(new Bits(RefArrays.copyOf((byte[])buffer, (int)bytesRead)));
        }
        return this.remainder;
    }

    public boolean readBool() throws IOException {
        return Bits.ONE.equals(this.read(1));
    }

    public long readBoundedLong(long max) throws IOException {
        int bits = 0L >= max ? 0 : (int)(Math.floor(Math.log(max) / Math.log(2.0)) + 1.0);
        return 0 < bits ? this.read(bits).toLong() : 0L;
    }

    public long readVarLong() throws IOException {
        int type = (int)this.read(2).toLong();
        return this.read(BitOutputStream.varLongDepths[type]).toLong();
    }

    public long peekLongCoord(long max) throws IOException {
        if (1L >= max) {
            return 0L;
        }
        int bits = 1 + (int)Math.ceil(Math.log(max) / Math.log(2.0));
        Bits peek = this.peek(bits);
        double divisor = 1 << peek.bitLength;
        long value = (int)((double)peek.toLong() * (double)max / divisor);
        assert (0L <= value);
        assert (max >= value);
        return value;
    }

    public int peekIntCoord(int max) throws IOException {
        if (1 >= max) {
            return 0;
        }
        int bits = 1 + (int)Math.ceil(Math.log(max) / Math.log(2.0));
        Bits peek = this.peek(bits);
        double divisor = 1 << peek.bitLength;
        int value = (int)((double)peek.toLong() * (double)max / divisor);
        assert (0 <= value);
        assert (max >= value);
        return value;
    }

    public short readVarShort() throws IOException {
        return this.readVarShort(7);
    }

    public short readVarShort(int optimal) throws IOException {
        int[] varShortDepths = new int[]{optimal, 16};
        int type = (int)this.read(1).toLong();
        return (short)this.read(varShortDepths[type]).toLong();
    }

    public char readChar() throws IOException {
        return (char)this.read(16).toLong();
    }
}

