/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.binary.bitset;

import com.simiacryptus.ref.wrappers.RefMap;
import com.simiacryptus.util.CountCollection;
import com.simiacryptus.util.binary.BitInputStream;
import com.simiacryptus.util.binary.BitOutputStream;
import com.simiacryptus.util.binary.Bits;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BitsCollection<C extends RefMap<Bits, AtomicInteger>>
extends CountCollection<Bits, C> {
    public final @Nullable Integer bitDepth;

    public BitsCollection(C collection) {
        super(collection);
        this.bitDepth = null;
    }

    public BitsCollection(int bitDepth, C collection) {
        super(collection);
        this.bitDepth = bitDepth;
    }

    public @Nonnull CodeType getType(@Nonnull Bits bits) {
        if (null != this.bitDepth) {
            if (bits.bitLength == this.bitDepth) {
                return CodeType.Terminal;
            }
            if (bits.bitLength < this.bitDepth) {
                return CodeType.Prefix;
            }
            throw new IllegalArgumentException();
        }
        return CodeType.Unknown;
    }

    public abstract void read(BitInputStream var1) throws IOException;

    public abstract void write(BitOutputStream var1) throws IOException;

    @Override
    public void _free() {
        super._free();
    }

    public @Nonnull BitsCollection<C> addRef() {
        return (BitsCollection)super.addRef();
    }

    public static enum CodeType {
        Terminal,
        Prefix,
        Unknown;

    }
}

