/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.data;

import com.simiacryptus.util.data.SerialArrayList;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public interface SerialType<T> {
    public int getSize();

    default public @Nonnull SerialArrayList<T> newList() {
        return new SerialArrayList(this);
    }

    default public @Nonnull SerialArrayList<T> newList(int size) {
        return new SerialArrayList(this, size);
    }

    default public @Nonnull SerialArrayList<T> newList(T ... items) {
        return new SerialArrayList<T>(this, items);
    }

    public @Nonnull T read(ByteBuffer var1) throws IOException;

    default public @Nonnull T read(@Nonnull byte[] input) throws IOException {
        if (!1.$assertionsDisabled && input.length != this.getSize()) {
            throw new AssertionError();
        }
        return this.read(ByteBuffer.wrap(input));
    }

    public void write(ByteBuffer var1, T var2) throws IOException;

    default public @Nonnull byte[] write(T value) throws IOException {
        byte[] buffer = new byte[this.getSize()];
        this.write(ByteBuffer.wrap(buffer), value);
        return buffer;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

