/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.io;

import com.simiacryptus.ref.lang.RefAware;
import com.simiacryptus.ref.wrappers.RefIterator;
import com.simiacryptus.ref.wrappers.RefIteratorBase;
import com.simiacryptus.ref.wrappers.RefSpliterators;
import com.simiacryptus.ref.wrappers.RefStream;
import com.simiacryptus.ref.wrappers.RefStreamSupport;
import com.simiacryptus.util.Util;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Spliterator;
import javax.annotation.Nonnull;

public final class BinaryChunkIterator
extends RefIteratorBase<byte[]> {
    private final DataInputStream in;
    private final int recordSize;

    public BinaryChunkIterator(DataInputStream in, int recordSize) {
        this.in = in;
        this.recordSize = recordSize;
    }

    public static <T> RefStream<T> toIterator(@Nonnull RefIterator<T> iterator) {
        return RefStreamSupport.stream((Spliterator)RefSpliterators.spliterator(iterator, (int)1, (int)16), (boolean)false);
    }

    public static <T> RefStream<T> toStream(@Nonnull RefIteratorBase<T> iterator) {
        return BinaryChunkIterator.toStream(iterator, 0);
    }

    public static <T> RefStream<T> toStream(@RefAware @Nonnull RefIteratorBase<T> iterator, int size) {
        return BinaryChunkIterator.toStream(iterator, size, false);
    }

    public static <T> RefStream<T> toStream(@RefAware @Nonnull RefIteratorBase<T> iterator, int size, boolean parallel) {
        return RefStreamSupport.stream((Spliterator)RefSpliterators.spliterator(iterator, (int)size, (int)16), (boolean)parallel);
    }

    private static @Nonnull byte[] read(@Nonnull DataInputStream i, int s) throws IOException {
        int read;
        @Nonnull byte[] b = new byte[s];
        for (int pos = 0; b.length > pos; pos += read) {
            read = i.read(b, pos, b.length - pos);
            if (0 != read) continue;
            throw new RuntimeException();
        }
        return b;
    }

    public boolean hasNext() {
        try {
            return 0 < this.in.available();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public @Nonnull byte[] next() {
        assert (this.hasNext());
        try {
            return BinaryChunkIterator.read(this.in, this.recordSize);
        }
        catch (IOException e) {
            throw Util.throwException(e);
        }
    }

    public RefStream<byte[]> toStream() {
        return BinaryChunkIterator.toStream(this.addRef());
    }

    public void _free() {
        super._free();
    }

    public @Nonnull BinaryChunkIterator addRef() {
        return (BinaryChunkIterator)super.addRef();
    }
}

