/*
 * Decompiled with CFR 0.152.
 */
package com.simtechdata.googleauthdecoder;

import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import com.simtechdata.googleauthdecoder.HTMLDecoding;
import com.simtechdata.googleauthdecoder.OTPRecord;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class Decoder {
    private final File imageFile;
    private final String userHome = System.getProperty("user.home");
    private final File workFolder;
    private final File outFile;
    private final int size;
    private final String OSystem = System.getProperty("os.name").toLowerCase();
    private final String source = "source";
    private final String outFilename = "output.txt";
    private final String sourcePycache = "pycache";
    private final String pycache = "__pycache__";
    private final List<OTPRecord> otpRecords = new LinkedList<OTPRecord>();
    private List<String> otpLines;
    private File sourceFolder;
    private File pycacheFolder;

    public Decoder(File imageFile) {
        this.size = 1000;
        this.imageFile = imageFile;
        this.workFolder = this.getOS().equals((Object)OS.WINDOWS) ? new File(System.getenv("APPDATA"), "GoogleAuthDecoder") : new File(this.userHome, ".googleAuthDecoder");
        Path outFilePath = Paths.get(this.workFolder.getAbsolutePath(), "source", "output.txt");
        this.outFile = outFilePath.toFile();
        this.workFolder.mkdir();
        this.makeOutFolders();
        this.copyFiles();
    }

    public Decoder(File imageFile, int size) {
        this.size = size;
        this.imageFile = imageFile;
        this.workFolder = this.getOS().equals((Object)OS.WINDOWS) ? new File(System.getenv("APPDATA"), "GoogleAuthDecoder") : new File(this.userHome, ".googleAuthDecoder");
        Path outFilePath = Paths.get(this.workFolder.getAbsolutePath(), "source", "output.txt");
        this.outFile = outFilePath.toFile();
        this.workFolder.mkdir();
        this.makeOutFolders();
        this.copyFiles();
    }

    public void decode() {
        try {
            if (this.imageFile.exists()) {
                this.changeSize();
                String oauthString = this.extractStringFromQRFile();
                this.runProcess(oauthString);
                this.otpLines = FileUtils.readLines((File)this.outFile, (Charset)StandardCharsets.UTF_8);
                if (this.otpLines.size() == 0) {
                    System.out.println("No data was found, is the Python3.9 bin folder in your PATH environment variable?");
                } else {
                    this.extractData();
                }
            } else {
                System.out.println("Image file does not exist.");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.cleanup();
    }

    public List<OTPRecord> getRecords() {
        return this.otpRecords;
    }

    public List<String> getRawOTP() {
        return this.otpLines;
    }

    private void cleanup() {
        try {
            FileUtils.deleteDirectory((File)this.workFolder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void info() {
        String info = "\t\t\tIn order to use this library, you must have Python 3.9 installed and the bin folder of your Python 3.9 installation\n\t\t\tmust be in your path environment variable.\n\nIn addition to Python 3.9, you must run this from your command line at least one time so that the resource is available\nto the library when it does the conversion:\n\npip3.9 install click\n\nThe rest is easy.\n\nFirst, open Google Authenticator and tap on the ellipses at the upper right and chose to export your accounts.\n\nNext, click on continue then authenticate however it asks you to do so.\n\nAll of the accounts should be selected at which point you click on Export at the bottom right of the screen.\n\nTake a screen shot and save it to wherever you're going to use this library.\n\nYou can click on CANCEL at the upper right instead of Next, because when you click on Next, it's going to want to delete all\nof your accounts in Google Authenticator and that might not be of interest to you.\n\nThe last thing you need to do, is crop that screen shot so that it only has the QR code in the image, then save it as a .PNG file.\n\nUse that file as the File object that you pass into the constructor.\n\nSimply instantiate the library by passing the java.nio.File object into the constructor, where the File\npoints to the CROPPED screen shot that you took from Google Authenticator.\n\nif your cropped image is larger than 1,000 pixels in either dimension, then use the second constructor and pass in a size\nthat is the next 50 number above your image size. So, for example, if your image is 1430 x 1430, then pass in 1450 as the size.\n";
        System.out.println(info);
    }

    private void extractData() {
        String otpAuthString = "";
        String otpType = "";
        String otpName = "";
        String otpParams = "";
        String algorithm = "";
        String digits = "";
        String issuer = "";
        String secret = "";
        for (String oauth : this.otpLines) {
            String[] items = oauth.split("&");
            String[] otpauthItems = items[0].split("\\?");
            ArrayList<String> itemsList = new ArrayList<String>(Arrays.asList(items));
            ArrayList<String> otpauthItemsList = new ArrayList<String>(Arrays.asList(otpauthItems));
            for (String item : otpauthItemsList) {
                if (item.contains("otpauth:")) {
                    otpAuthString = this.decodeHTML(item);
                    otpType = this.getType(otpAuthString);
                    otpName = this.getName(otpAuthString);
                    otpParams = this.getParams(oauth);
                }
                if (!item.contains("algorithm=")) continue;
                algorithm = item.replace("algorithm=", "");
            }
            for (String item : itemsList) {
                if (item.contains("digits=")) {
                    digits = item.replace("digits=", "");
                }
                if (item.contains("issuer=")) {
                    issuer = item.replace("issuer=", "");
                }
                if (!item.contains("secret=")) continue;
                secret = item.replace("secret=", "");
            }
            this.otpRecords.add(new OTPRecord(otpAuthString, otpType, otpName, otpParams, algorithm, digits, issuer, secret));
        }
    }

    private String decodeHTML(String source) {
        String regex = "(%[a-zA-Z0-9]{2})";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(source);
        String outString = source;
        while (m.find()) {
            outString = outString.replace(m.group(1), HTMLDecoding.get(m.group(1)));
        }
        return outString;
    }

    private String getType(String source) {
        String regex = "(otpauth://)([a-zA-Z0-9]+)(/)";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(source);
        String outString = source;
        if (m.find()) {
            outString = m.group(2);
        }
        return outString;
    }

    private String getName(String source) {
        String regex = "(otpauth://)([a-zA-Z0-9]+)(/)(.+)(?)";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(source);
        String outString = source;
        if (m.find()) {
            outString = m.group(4);
        }
        return outString;
    }

    private String getParams(String source) {
        String regex = "(otpauth://)(.+)(/)(.+)(\\?)(.+)(&)(.+)(&)(.+)(&)";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(source);
        String outString = "";
        if (m.find()) {
            outString = m.group(6);
        }
        return outString;
    }

    private String decodeBufferedQRImage(BufferedImage bufferedImage) {
        Result result = null;
        try {
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(bufferedImage);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            result = new MultiFormatReader().decode(bitmap);
            byte[] resultBytes = result.getRawBytes();
            String string = result.getText();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        return result == null ? "" : result.getText();
    }

    private String extractStringFromQRFile() {
        boolean invalidQRCode = true;
        String otpAuth = "";
        try {
            BufferedImage bufferedImage = ImageIO.read(this.imageFile);
            Image image = bufferedImage.getScaledInstance(500, 500, 1);
            otpAuth = this.decodeBufferedQRImage(bufferedImage);
            invalidQRCode = otpAuth.equals("");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!invalidQRCode) {
            return otpAuth;
        }
        return null;
    }

    private void changeSize() {
        try {
            int w = this.size;
            int h = this.size;
            BufferedImage inputImage = ImageIO.read(this.imageFile);
            BufferedImage img = new BufferedImage(w, h, inputImage.getType());
            Graphics2D g = img.createGraphics();
            g.drawImage(inputImage, 0, 0, w, h, null);
            g.dispose();
            String name = this.imageFile.getName().substring(this.imageFile.getName().lastIndexOf(".") + 1).toUpperCase();
            ImageIO.write((RenderedImage)img, name, this.imageFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private LinkedList<URL> getResourceFolderFiles(String subFolder) {
        String folder = "pythonSource/" + subFolder;
        LinkedList<URL> fileList = new LinkedList<URL>();
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().scan();){
            ResourceList resources = scanResult.getAllResources();
            for (URL url : resources.getURLs()) {
                if (!url.toString().contains(folder)) continue;
                fileList.addLast(url);
            }
        }
        return fileList;
    }

    private void makeOutFolders() {
        this.sourceFolder = new File(this.workFolder, "source");
        this.pycacheFolder = new File(this.sourceFolder, "__pycache__");
        if (!this.sourceFolder.exists()) {
            this.sourceFolder.mkdir();
        }
        if (!this.pycacheFolder.exists()) {
            this.pycacheFolder.mkdir();
        }
    }

    private void copyFiles() {
        try {
            File outFile;
            String filename;
            LinkedList<URL> srcFileList = this.getResourceFolderFiles("source");
            LinkedList<URL> pycacheFiles = this.getResourceFolderFiles("pycache");
            for (URL url : srcFileList) {
                filename = FilenameUtils.getName((String)url.toString());
                outFile = new File(this.sourceFolder, filename);
                FileUtils.copyURLToFile((URL)url, (File)outFile);
            }
            for (URL url : pycacheFiles) {
                filename = FilenameUtils.getName((String)url.toString());
                outFile = new File(this.pycacheFolder, filename.replace(".fil", ""));
                FileUtils.copyURLToFile((URL)url, (File)outFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private OS getOS() {
        if (this.OSystem.toLowerCase().contains("win")) {
            return OS.WINDOWS;
        }
        if (this.OSystem.toLowerCase().contains("mac")) {
            return OS.MAC;
        }
        return OS.LINUX;
    }

    private void runProcess(String oauthString) {
        try {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            String command = "python3.9 decoder.py --convert \"" + oauthString + "\" > output.txt";
            if (this.getOS().equals((Object)OS.WINDOWS)) {
                builder.command("cmd.exe", "-c", command);
            } else {
                builder.command("sh", "-c", command);
            }
            File workingFolder = new File(this.workFolder, "source");
            builder.directory(workingFolder);
            Process process = builder.start();
            StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), System.out::println);
            Executors.newSingleThreadExecutor().submit(streamGobbler);
            int exitCode = process.waitFor();
            assert (exitCode == 0);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum OS {
        WINDOWS,
        MAC,
        LINUX;

    }

    private record StreamGobbler(InputStream inputStream, Consumer<String> consumer) implements Runnable
    {
        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumer);
        }
    }
}

