/*
 * Decompiled with CFR 0.152.
 */
package com.simtechdata;

import com.simtechdata.HistoryKeeper;
import com.simtechdata.SceneObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class Switcher {
    private static final BooleanProperty stageVisibleProperty = new SimpleBooleanProperty(true);
    private static final BooleanProperty hideSceneOnLostFocusProperty = new SimpleBooleanProperty(false);
    private static final BooleanProperty visibleWithHistoryProperty = new SimpleBooleanProperty();
    private static final BooleanProperty enabledWithHistoryProperty = new SimpleBooleanProperty();
    private static final Map<Integer, SceneObject> sceneObjectMap = new HashMap<Integer, SceneObject>();
    private static final Map<Integer, Stage> stageMap = new HashMap<Integer, Stage>();
    private static final Map<Integer, EventHandler<Event>> sceneShownMap = new HashMap<Integer, EventHandler<Event>>();
    private static final List<Integer> randomInts = new ArrayList<Integer>();
    private static boolean firstRun = true;
    private static final HistoryKeeper history = new HistoryKeeper();
    private static Stage stage;
    private static Integer defaultStageID;
    private static Integer showingSceneID;
    private static Integer lastSceneIDShowing;
    private static final ChangeListener<Boolean> lostFocusListener;

    public static void addScene(Integer sceneID, Parent root, double width, double height) {
        Switcher.addSceneObject(sceneID, null, root, width, height, null);
    }

    public static void addScene(Integer sceneID, Parent root, double width, double height, StageStyle initStyle, Modality initModality) {
        Switcher.addSceneObject(sceneID, null, root, width, height, null);
        stageMap.get(defaultStageID).initStyle(initStyle);
        stageMap.get(defaultStageID).initModality(initModality);
    }

    public static void addScene(Integer sceneID, Integer stageID, Parent root, double width, double height, StageStyle initStyle, Modality initModality) {
        if (!stageMap.containsKey(stageID)) {
            Stage stage = new Stage();
            if (initStyle != null) {
                stage.initStyle(initStyle);
            }
            if (initModality != null) {
                stage.initModality(initModality);
            }
            stageMap.put(stageID, stage);
        }
        Switcher.checkForIDConflict(stageID);
        Switcher.addSceneObject(sceneID, stageID, root, width, height, null);
    }

    public static void addScene(Integer sceneID, Integer stageID, Parent root, double width, double height, StageStyle initStyle) {
        Switcher.checkForIDConflict(stageID);
        if (!stageMap.containsKey(stageID)) {
            Stage stage = new Stage();
            if (initStyle != null) {
                stage.initStyle(initStyle);
            }
            stageMap.put(stageID, stage);
        }
        Switcher.addSceneObject(sceneID, stageID, root, width, height, null);
    }

    public static void addScene(Integer sceneID, Integer stageID, Parent root, double width, double height, Modality initModality) {
        Switcher.checkForIDConflict(stageID);
        if (!stageMap.containsKey(stageID)) {
            Stage stage = new Stage();
            if (initModality != null) {
                stage.initModality(initModality);
            }
            stageMap.put(stageID, stage);
        }
        Switcher.addSceneObject(sceneID, stageID, root, width, height, null);
    }

    public static void addScene(Integer sceneID, Integer stageID, Parent root, double width, double height) {
        Switcher.checkForIDConflict(stageID);
        if (!stageMap.containsKey(stageID)) {
            Stage stage = new Stage();
            stageMap.put(stageID, stage);
        }
        Switcher.addSceneObject(sceneID, stageID, root, width, height, null);
    }

    public static void addScene(Integer sceneID, Scene scene, Stage stage) {
        Integer newStageID = Switcher.getRandom();
        stageMap.put(newStageID, stage);
        Switcher.addSceneObject(sceneID, newStageID, null, null, null, scene);
    }

    public static void addStage(Integer stageID, Stage stage) {
        Switcher.checkForIDConflict(stageID);
        if (!stageMap.containsKey(stageID)) {
            stageMap.put(stageID, stage);
        } else {
            System.err.println("addStage - stageID " + stageID + " ALREADY EXIST USE removeStage first");
        }
    }

    public static void removeScene(Integer sceneID) {
        if (sceneObjectMap.containsKey(sceneID)) {
            sceneObjectMap.remove(sceneID);
        } else {
            Switcher.warnNoScene("removeScene", sceneID);
        }
    }

    public static void removeStage(Integer stageID) {
        if (stageMap.containsKey(stageID)) {
            stageMap.remove(stageID);
            for (Integer sid : sceneObjectMap.keySet()) {
                SceneObject so = sceneObjectMap.get(sid);
                if (!so.getStageID().equals(stageID)) continue;
                so.setStageID(null);
                sceneObjectMap.replace(sid, so);
            }
        } else {
            Switcher.warnNoStage("removeStage", stageID);
        }
    }

    public static void assignSceneToStage(Integer sceneID, Integer stageID) {
        if (sceneObjectMap.containsKey(sceneID)) {
            sceneObjectMap.get(sceneID).setStageID(stageID);
        } else {
            Switcher.warnNoScene("assignSceneToStage", sceneID);
        }
    }

    public static void configureDefaultStage(StageStyle initStyle, Modality initModality) {
        Platform.runLater(() -> {
            if (!stageMap.containsKey(defaultStageID)) {
                stageMap.put(defaultStageID, new Stage());
            }
            if (initStyle != null) {
                stageMap.get(defaultStageID).initStyle(initStyle);
            }
            if (initModality != null) {
                stageMap.get(defaultStageID).initModality(initModality);
            }
        });
    }

    public static Stage getStage(Integer stageID) {
        if (stageID == null) {
            return Switcher.getDefaultStage();
        }
        if (stageMap.containsKey(stageID)) {
            return stageMap.get(stageID);
        }
        Switcher.warnNoStage("getStage", stageID);
        return null;
    }

    public static Stage getDefaultStage() {
        if (!stageMap.containsKey(defaultStageID)) {
            stageMap.put(defaultStageID, new Stage());
        }
        return stageMap.get(defaultStageID);
    }

    public static Scene getScene(Integer sceneID) {
        if (sceneObjectMap.containsKey(sceneID)) {
            return sceneObjectMap.get(sceneID).getScene();
        }
        Switcher.warnNoScene("getScene", sceneID);
        return null;
    }

    public static void setHideOnLostFocus(boolean hideOnLostFocus) {
        hideSceneOnLostFocusProperty.setValue(Boolean.valueOf(hideOnLostFocus));
        for (Integer index : sceneObjectMap.keySet()) {
            sceneObjectMap.get(index).setHiddenOnLostFocus(hideOnLostFocus);
        }
    }

    public static void setHideOnLostFocus(Integer sceneID, boolean hideOnLostFocus) {
        if (sceneObjectMap.containsKey(sceneID)) {
            sceneObjectMap.get(sceneID).setHiddenOnLostFocus(hideOnLostFocus);
        } else {
            Switcher.warnNoScene("setHideOnLostFocus", sceneID);
        }
    }

    public static void setHideSceneOnLostFocus(boolean hideOnLostFocus) {
        Switcher.setHideOnLostFocus(hideOnLostFocus);
    }

    public static boolean sceneHiddenOnLostFocus() {
        return hideSceneOnLostFocusProperty.getValue();
    }

    public static Boolean sceneHiddenOnLostFocus(Integer sceneID) {
        if (sceneObjectMap.containsKey(sceneID)) {
            return sceneObjectMap.get(sceneID).hideOnLostFocus();
        }
        Switcher.warnNoScene("sceneHiddenOnLostFocus", sceneID);
        return null;
    }

    public static void setSceneVisible(boolean visible) {
        if (visible) {
            Switcher.unHide();
        } else {
            Switcher.hide();
        }
    }

    public static void hide() {
        lastSceneIDShowing = showingSceneID;
        showingSceneID = null;
        stageVisibleProperty.setValue(Boolean.valueOf(false));
    }

    public static void unHide() {
        if (showingSceneID == null) {
            showingSceneID = lastSceneIDShowing;
        }
        stageVisibleProperty.setValue(Boolean.valueOf(true));
    }

    public static boolean sceneVisible() {
        return Switcher.visible();
    }

    public static boolean visible() {
        return stageVisibleProperty.getValue();
    }

    public static void showScene(Integer sceneID) {
        Platform.runLater(() -> {
            if (sceneObjectMap.containsKey(sceneID)) {
                Switcher.showSceneObject(sceneID, true);
                if (sceneShownMap.containsKey(sceneID)) {
                    sceneShownMap.get(sceneID).handle((Event)new ActionEvent());
                }
            } else {
                Switcher.warnNoScene("showScene", sceneID);
            }
        });
    }

    public static void showScene(Integer sceneID, double width, double height, double stageX, double stageY) {
        Platform.runLater(() -> {
            if (sceneObjectMap.containsKey(sceneID)) {
                SceneObject sceneObject = sceneObjectMap.get(sceneID);
                sceneObject.setStageWidth(width);
                sceneObject.setStageHeight(height);
                sceneObject.setStageX(stageX);
                sceneObject.setStageY(stageY);
                Switcher.showSceneObject(sceneID, true);
                if (sceneShownMap.containsKey(sceneID)) {
                    sceneShownMap.get(sceneID).handle((Event)new ActionEvent());
                }
            } else {
                Switcher.warnNoScene("showScene", sceneID);
            }
        });
    }

    public static void showSceneWithPosition(Integer sceneID, double stageX, double stageY) {
        Platform.runLater(() -> {
            if (stageX < 0.0 || stageY < 0.0) {
                System.err.println("Values for X and Y in showScene must not be negative");
            } else if (sceneObjectMap.containsKey(sceneID)) {
                SceneObject so = sceneObjectMap.get(sceneID);
                so.setStageX(stageX);
                so.setStageY(stageY);
                so.setCustomXY(true);
                Switcher.showSceneObject(sceneID, true);
                if (sceneShownMap.containsKey(sceneID)) {
                    sceneShownMap.get(sceneID).handle((Event)new ActionEvent());
                }
            } else {
                Switcher.warnNoScene("showScene", sceneID);
            }
        });
    }

    public static void showSceneWithSize(Integer sceneID, double width, double height) {
        Platform.runLater(() -> {
            if (sceneObjectMap.containsKey(sceneID)) {
                SceneObject sceneObject = sceneObjectMap.get(sceneID);
                sceneObject.setStageWidth(width);
                sceneObject.setStageHeight(height);
                Switcher.showSceneObject(sceneID, true);
                if (sceneShownMap.containsKey(sceneID)) {
                    sceneShownMap.get(sceneID).handle((Event)new ActionEvent());
                }
            } else {
                Switcher.warnNoScene("showScene", sceneID);
            }
        });
    }

    public static boolean isShowing(Integer sceneID) {
        if (showingSceneID == null) {
            return false;
        }
        return sceneID.equals(showingSceneID);
    }

    public static BooleanProperty getVisibleWithHistoryProperty() {
        return visibleWithHistoryProperty;
    }

    public static BooleanProperty getEnabledWithHistoryProperty() {
        return enabledWithHistoryProperty;
    }

    public static void showLastScene() {
        Platform.runLater(() -> {
            Integer lastSceneID = history.getLastSceneID();
            System.out.println("LastSceneID: " + lastSceneID);
            Switcher.showSceneObject(lastSceneID, false);
            if (sceneShownMap.containsKey(lastSceneID)) {
                sceneShownMap.get(lastSceneID).handle((Event)new ActionEvent());
            }
        });
    }

    public static void setOnShown(Integer sceneId, EventHandler<Event> handler) {
        if (sceneObjectMap.containsKey(sceneId)) {
            sceneShownMap.put(sceneId, handler);
        }
    }

    private static void showSceneObject(Integer sceneID, boolean showingNewScene) {
        showingSceneID = sceneID;
        SceneObject sceneObject = sceneObjectMap.get(sceneID);
        if (showingNewScene) {
            history.showingNewScene(sceneID);
        }
        visibleWithHistoryProperty.setValue(Boolean.valueOf(history.hasHistory()));
        enabledWithHistoryProperty.setValue(Boolean.valueOf(!history.hasHistory()));
        stage = sceneObject.getStageID() == null ? stageMap.get(defaultStageID) : stageMap.get(sceneObject.getStageID());
        Scene scene = sceneObject.getScene();
        double stageX = sceneObject.getStageX();
        double stageY = sceneObject.getStageY();
        double stageWidth = sceneObject.getWidth() == null ? stage.getWidth() : sceneObject.getWidth().doubleValue();
        double stageHeight = sceneObject.getHeight() == null ? stage.getHeight() : sceneObject.getHeight().doubleValue();
        boolean customXY = sceneObject.hasCustomXY();
        stage.setScene(scene);
        if (sceneObject.hideOnLostFocus()) {
            stage.focusedProperty().addListener(lostFocusListener);
        } else {
            stage.focusedProperty().removeListener(lostFocusListener);
        }
        Platform.runLater(() -> {
            Rectangle2D screenBounds = Screen.getPrimary().getVisualBounds();
            double screenWidth = screenBounds.getWidth();
            double screenHeight = screenBounds.getHeight();
            double finalX = customXY ? stageX : screenWidth - screenWidth / 2.0 - stageWidth / 2.0;
            double finalY = customXY ? stageY : screenHeight - screenHeight / 2.0 - stageHeight / 2.0;
            stage.setX(finalX);
            stage.setY(finalY);
            stage.show();
            stage.toFront();
            stage.requestFocus();
        });
    }

    private static void hideStage() {
        Platform.runLater(() -> {
            if (stage != null) {
                stage.hide();
            }
        });
    }

    private static void showStage() {
        Platform.runLater(() -> {
            if (stage != null) {
                stage.show();
                stage.requestFocus();
            }
        });
    }

    private static void warnNoScene(String callingMethod, Integer sceneID) {
        System.err.println("sceneID " + sceneID + " does not exist being called from method " + callingMethod);
    }

    private static void warnNoStage(String callingMethod, Integer stageID) {
        System.err.println("stageID " + stageID + " does not exist being called from method " + callingMethod);
    }

    private static Integer getRandom() {
        int min = 1000000;
        int max = 9999999;
        Integer finalInt = ThreadLocalRandom.current().nextInt(min, max + 1);
        while (randomInts.contains(finalInt) || stageMap.containsKey(finalInt)) {
            finalInt = ThreadLocalRandom.current().nextInt(min, max + 1);
        }
        randomInts.add(finalInt);
        return finalInt;
    }

    private static void addSceneObject(Integer sceneID, Integer stageID, Parent parent, Double width, Double height, Scene scene) {
        if (firstRun) {
            if (!stageMap.containsKey(defaultStageID)) {
                stageMap.put(defaultStageID, new Stage());
            }
            stageVisibleProperty.addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    Switcher.showStage();
                } else {
                    Switcher.hideStage();
                }
            });
            firstRun = false;
        }
        if (parent == null) {
            sceneObjectMap.put(sceneID, new SceneObject(stageID, scene, width, height));
        } else {
            sceneObjectMap.put(sceneID, new SceneObject(stageID, parent, width, height));
        }
        sceneObjectMap.get(sceneID).setHiddenOnLostFocus(hideSceneOnLostFocusProperty.getValue());
    }

    private static void checkForIDConflict(Integer stageID) {
        if (randomInts.contains(stageID) || stageID.equals(defaultStageID)) {
            Integer oldDefaultStageID = defaultStageID;
            defaultStageID = Switcher.getRandom();
            stageMap.put(defaultStageID, stageMap.get(oldDefaultStageID));
            stageMap.remove(oldDefaultStageID);
        }
    }

    static {
        defaultStageID = Switcher.getRandom();
        lostFocusListener = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!newValue.booleanValue()) {
                    Platform.runLater(() -> stage.hide());
                }
            }
        };
    }
}

