package com.manageengine.apminsight.agent.api;

import com.manageengine.apminsight.agent.JavaAgentAPIHandler;

/**
 * Allows users to push custom metrics to APM Insight servers
 * 
 * @since 3.5.0
 * @author adithyan-2116
 */
public final class CustomTracker
{
	/**
	 * Associates the exception to the currently running transaction. Accepts custom exception message.
	 * 
	 * @param message - Custom error message
	 * @param throwable - Exception object to be tracked
	 */
	public static void trackException(String message, Throwable throwable)
	{
		try {
			JavaAgentAPIHandler.handleException(System.currentTimeMillis(), message, throwable);
		}
		catch(Throwable th) {
			// do nothing
		}
	}
	
	/**
	 * Associates the exception to the currently running transaction
	 * 
	 * @param throwable - Exception object to be tracked
	 */
	public static void trackException(Throwable throwable)
	{
		if (throwable != null) {
			trackException(throwable.getMessage(), throwable);
		}
	}
}
