/*
 * Decompiled with CFR 0.152.
 */
package com.skysql.java;

import com.skysql.java.Logging;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.ini4j.Ini;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Profile;

public class Configuration {
    private static final String DEFAULT_FILEPATH = "/etc/mariadbmanager/manager.ini";
    private static DEFAULT_SECTION RUNNING_APPLICATION = DEFAULT_SECTION.MONITOR;
    private String m_filePath;
    private Map<String, Map<String, String>> m_config = new HashMap<String, Map<String, String>>();
    private Ini m_ini;

    public Configuration() {
        this(DEFAULT_FILEPATH);
    }

    public Configuration(String filePath) {
        this.m_filePath = filePath;
        this.reloadFile();
        this.reloadAll();
    }

    public static DEFAULT_SECTION getApplication() {
        return RUNNING_APPLICATION;
    }

    public static void setApplication(DEFAULT_SECTION application) {
        RUNNING_APPLICATION = application;
    }

    private void reloadFile() {
        Logging.info("Loading configuration file " + this.m_filePath);
        try {
            this.m_ini = new Ini(new File(this.m_filePath));
        }
        catch (InvalidFileFormatException e) {
            Logging.error(e.getMessage());
            return;
        }
        catch (IOException e) {
            Logging.error("I/O error while reading file " + this.m_filePath);
            return;
        }
    }

    public void reload(DEFAULT_SECTION section, boolean reloadFile) {
        Profile.Section sectionConfig;
        String sectionName = section.getSectionName();
        Logging.info("Loading configuration section [" + sectionName + "]");
        if (reloadFile) {
            this.reloadFile();
        }
        if ((sectionConfig = (Profile.Section)this.m_ini.get(sectionName)) == null) {
            Logging.info("Section " + sectionName + " not found");
            return;
        }
        for (String key : sectionConfig.keySet()) {
            sectionConfig.put(key, this.validateValue((String)sectionConfig.get(key)));
        }
        this.m_config.put(sectionName, sectionConfig);
    }

    public void reloadAll() {
        for (DEFAULT_SECTION section : DEFAULT_SECTION.values()) {
            this.reload(section, false);
        }
    }

    public Map<String, Map<String, String>> getConfig() {
        return this.m_config;
    }

    public Map<String, String> getConfig(String section) {
        return this.m_config.get(section);
    }

    public Map<String, String> getConfig(DEFAULT_SECTION section) {
        return this.m_config.get(section.getSectionName());
    }

    private String validateValue(String value) {
        String result = "";
        result = "None".equalsIgnoreCase(value) || value.isEmpty() ? "" : (this.equalsOneOf(value, "On", "True", "Yes") ? "true" : (this.equalsOneOf(value, "Off", "False", "No") ? "false" : value.replaceAll("^\"|\"$", "")));
        return result;
    }

    private boolean equalsOneOf(String value, String ... strings) {
        boolean result = false;
        for (String string : strings) {
            result = result || value.equalsIgnoreCase(string);
        }
        return result;
    }

    public static enum DEFAULT_SECTION {
        APIKEYS("apikeys"),
        APIHOST("apihost"),
        MONITOR("monitor"),
        WEBUI("ui");

        private final String sectionName;

        private DEFAULT_SECTION(String sectionName) {
            this.sectionName = sectionName;
        }

        public String getSectionName() {
            return this.sectionName;
        }
    }
}

