/*
 * Decompiled with CFR 0.152.
 */
package com.skysql.java;

import com.skysql.java.GsonMonitorClasses;
import com.skysql.java.GsonNode;
import com.skysql.java.GsonSystem;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class GsonLatestObservations {
    private String m_standardDate = "Thu, 01 Jan 1970 01:00:00 +0100";
    private LinkedHashMap<Integer, GsonSystem.Systems> m_system = new LinkedHashMap(3);
    private LinkedHashMap<Integer, LinkedHashMap<Integer, GsonNode.Nodes>> m_node = new LinkedHashMap(3);
    private LinkedHashMap<Integer, GsonMonitorClasses.MonitorClasses> m_monitor = new LinkedHashMap(3);
    private LinkedHashMap<Integer, String> m_systemDates = new LinkedHashMap(3);
    private LinkedHashMap<Integer, LinkedHashMap<Integer, String>> m_nodeDates = new LinkedHashMap(3);
    private String m_monitorDates = null;

    public GsonSystem getSystem(int systemID) {
        try {
            GsonSystem gsonSystem = new GsonSystem(this.m_system.get(systemID));
            return gsonSystem;
        }
        catch (Exception e) {
            return null;
        }
    }

    public GsonNode getNode(int systemID, int nodeID) {
        try {
            GsonNode gsonNode = new GsonNode(this.m_node.get(systemID).get(nodeID));
            return gsonNode;
        }
        catch (Exception e) {
            return null;
        }
    }

    public GsonNode getAllNodes(int systemID) {
        try {
            LinkedHashMap<Integer, GsonNode.Nodes> hmNodes = this.m_node.get(systemID);
            ArrayList<GsonNode.Nodes> nodeList = new ArrayList<GsonNode.Nodes>();
            for (Integer nodeID : hmNodes.keySet()) {
                nodeList.add(hmNodes.get(nodeID));
            }
            GsonNode gsonNode = new GsonNode(nodeList);
            return gsonNode;
        }
        catch (Exception e) {
            return null;
        }
    }

    public GsonMonitorClasses getMonitorClasses(int monitorID) {
        try {
            GsonMonitorClasses gsonMonitorClasses = new GsonMonitorClasses(this.m_monitor.get(monitorID));
            return gsonMonitorClasses;
        }
        catch (Exception e) {
            return null;
        }
    }

    public GsonMonitorClasses getAllMonitorClasses() {
        try {
            ArrayList<GsonMonitorClasses.MonitorClasses> monitorList = new ArrayList<GsonMonitorClasses.MonitorClasses>();
            for (Integer monitorID : this.m_monitor.keySet()) {
                monitorList.add(this.m_monitor.get(monitorID));
            }
            GsonMonitorClasses gsonMonitorClasses = new GsonMonitorClasses(monitorList);
            return gsonMonitorClasses;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getSystemUpdateDate(int systemID) {
        try {
            if (!this.m_systemDates.containsKey(systemID)) {
                throw new RuntimeException();
            }
            return this.m_systemDates.get(systemID);
        }
        catch (Exception e) {
            return this.m_standardDate;
        }
    }

    public String getNodeUpdateDate(int systemID, int nodeID) {
        try {
            if (!this.m_nodeDates.containsKey(systemID)) {
                throw new RuntimeException();
            }
            if (!this.m_nodeDates.get(systemID).containsKey(nodeID)) {
                throw new RuntimeException();
            }
            return this.m_nodeDates.get(systemID).get(nodeID);
        }
        catch (Exception e) {
            return this.m_standardDate;
        }
    }

    public String getMonitorUpdateDate() {
        String result;
        try {
            result = this.m_monitorDates;
            if (result == null || result.isEmpty()) {
                result = this.m_standardDate;
            }
        }
        catch (Exception e) {
            result = this.m_standardDate;
        }
        return result;
    }

    public void setLastSystem(GsonSystem systemObj) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
            String now = sdf.format(new Date());
            for (GsonSystem.Systems systemTmp : systemObj.getSystems()) {
                int systemID = systemTmp.getSystemId();
                this.m_system.put(systemID, systemTmp);
                this.m_systemDates.put(systemID, now);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLastNode(GsonNode nodeObj) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
            String now = sdf.format(new Date());
            for (GsonNode.Nodes nodeTmp : nodeObj.getNodes()) {
                int systemID = nodeTmp.getSystemId();
                int nodeID = nodeTmp.getNodeId();
                LinkedHashMap<Integer, GsonNode.Nodes> lhm = new LinkedHashMap<Integer, GsonNode.Nodes>(1);
                if (this.m_node != null && this.m_node.containsKey(systemID)) {
                    lhm = this.m_node.get(systemID);
                }
                lhm.put(nodeID, nodeTmp);
                this.m_node.put(systemID, lhm);
                LinkedHashMap<Integer, String> lhmDate = new LinkedHashMap<Integer, String>(1);
                if (this.m_nodeDates != null && this.m_nodeDates.containsKey(systemID)) {
                    lhmDate = this.m_nodeDates.get(systemID);
                }
                lhmDate.put(nodeID, now);
                this.m_nodeDates.put(systemID, lhmDate);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearAllNodes(int systemID) {
        try {
            this.m_node.get(systemID).clear();
            this.m_node.remove(systemID);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLastMonitor(GsonMonitorClasses monitorObj) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
            String now = sdf.format(new Date());
            Iterator<GsonMonitorClasses.MonitorClasses> it = monitorObj.getMonitorClasses().iterator();
            this.m_monitor.clear();
            while (it.hasNext()) {
                GsonMonitorClasses.MonitorClasses monitorTmp = it.next();
                Integer monitorID = monitorTmp.getMonitorId();
                this.m_monitor.put(monitorID, monitorTmp);
            }
            this.m_monitorDates = now;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

