/*
 * Decompiled with CFR 0.152.
 */
package com.skysql.java;

import com.google.gson.Gson;
import com.skysql.java.GsonErrors;
import com.skysql.java.Logging;

public class GsonManager {
    private static Gson gson = new Gson();

    public static <T> String toJson(T obj) {
        String result = gson.toJson(obj);
        return result;
    }

    public static <T> T fromJson(String inJson, Class<T> objClass) {
        try {
            GsonErrors gsonErrors;
            boolean errorFound = false;
            if (GsonErrors.class.isAssignableFrom(objClass) && (gsonErrors = gson.fromJson(inJson, GsonErrors.class)) != null) {
                if (gsonErrors.getErrors() != null) {
                    errorFound = true;
                    Logging.error("The API returned the following error(s): ");
                    for (String error : gsonErrors.getErrors()) {
                        Logging.error(error);
                    }
                }
                if (gsonErrors.getWarnings() != null) {
                    errorFound = true;
                    Logging.warn("The API returned the following warning(s): ");
                    for (String warning : gsonErrors.getWarnings()) {
                        Logging.warn(warning);
                    }
                }
                if (errorFound) {
                    return null;
                }
            }
            T resultObj = gson.fromJson(inJson, objClass);
            return resultObj;
        }
        catch (Exception e) {
            return null;
        }
    }
}

