/*
 * Decompiled with CFR 0.152.
 */
package com.skysql.java;

import com.skysql.java.GsonErrors;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GsonMonitorClasses
extends GsonErrors {
    private static final int ERROR_INT_RETURN = -1;
    private MonitorClasses monitorclass;
    private List<MonitorClasses> monitorclasses;

    public GsonMonitorClasses(MonitorClasses monitorClass) {
        this.monitorclass = monitorClass;
    }

    public GsonMonitorClasses(List<MonitorClasses> monitorClasses) {
        this.monitorclasses = monitorClasses;
    }

    public MonitorClasses getMonitorClass(int index) {
        if (index < 0) {
            return null;
        }
        if (this.getMonitorClasses() == null || this.getMonitorClasses().size() < index + 1) {
            return null;
        }
        return this.getMonitorClasses().get(index);
    }

    public List<MonitorClasses> getMonitorClasses() {
        if (this.monitorclasses != null) {
            return this.monitorclasses;
        }
        if (this.monitorclass == null) {
            return null;
        }
        ArrayList<MonitorClasses> listMonitorClasses = new ArrayList<MonitorClasses>(1);
        listMonitorClasses.add(this.monitorclass);
        return listMonitorClasses;
    }

    public GsonMonitorClasses() {
    }

    public List<Integer> getMonitorIdList() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (this.getMonitorClasses() != null) {
            Iterator<MonitorClasses> it = this.getMonitorClasses().iterator();
            while (it.hasNext()) {
                result.add(it.next().getMonitorId());
            }
        } else {
            return null;
        }
        return result;
    }

    public static class MonitorClasses {
        private String systemtype;
        private String monitor;
        private String name;
        private String sql;
        private String description;
        private String decimals;
        private String mapping;
        private String charttype;
        private String delta;
        private String monitortype;
        private String systemaverage;
        private String interval;
        private String unit;
        private String monitorid;

        public String getSystemType() {
            return this.systemtype;
        }

        public String getMonitor() {
            return this.monitor;
        }

        public String getName() {
            return this.name;
        }

        public String getSql() {
            return this.sql;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDecimals() {
            return this.decimals;
        }

        public String getMapping() {
            return this.mapping;
        }

        public String getChartType() {
            return this.charttype;
        }

        public int getDelta() {
            try {
                return Integer.parseInt(this.delta);
            }
            catch (NumberFormatException nfex) {
                return -1;
            }
        }

        public String getMonitorType() {
            return this.monitortype;
        }

        public int getSystemAverage() {
            try {
                return Integer.parseInt(this.systemaverage);
            }
            catch (NumberFormatException nfex) {
                return -1;
            }
        }

        public int getInterval() {
            try {
                return Integer.parseInt(this.interval);
            }
            catch (NumberFormatException nfex) {
                return -1;
            }
        }

        public String getUnit() {
            return this.unit;
        }

        public int getMonitorId() {
            try {
                return Integer.parseInt(this.monitorid);
            }
            catch (NumberFormatException nfex) {
                return -1;
            }
        }
    }
}

