/*
 * Decompiled with CFR 0.152.
 */
package com.skysql.java;

import com.skysql.java.GsonErrors;
import com.skysql.java.GsonSharedMonitorLatest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GsonNode
extends GsonErrors {
    private static final int ERROR_INT_RETURN = -1;
    private Nodes node;
    private List<Nodes> nodes;

    public GsonNode(Nodes node) {
        this.node = node;
    }

    public GsonNode(List<Nodes> nodes) {
        this.nodes = nodes;
    }

    private Nodes getNode() {
        return this.node;
    }

    public List<Nodes> getNodes() {
        if (this.nodes != null) {
            return this.nodes;
        }
        if (this.getNode() != null) {
            ArrayList<Nodes> listNodes = new ArrayList<Nodes>(1);
            listNodes.add(this.getNode());
            return listNodes;
        }
        return null;
    }

    public Nodes getNode(int index) {
        if (index < 0) {
            return null;
        }
        List<Nodes> dummy = this.getNodes();
        if (dummy == null || dummy.size() < index + 1) {
            return null;
        }
        return dummy.get(index);
    }

    public List<Integer> getNodeIdList() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (this.getNodes() != null) {
            Iterator<Nodes> it = this.getNodes().iterator();
            while (it.hasNext()) {
                result.add(it.next().getNodeId());
            }
        } else {
            return null;
        }
        return result;
    }

    public List<String> getNodeStateList() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getNodes() != null) {
            Iterator<Nodes> it = this.getNodes().iterator();
            while (it.hasNext()) {
                result.add(it.next().getState());
            }
        } else if (this.getNode() != null) {
            result.add(this.getNode().getState());
        } else {
            result = null;
        }
        return result;
    }

    public static class Commands {
        private String command;
        private String description;
        private String icon;
        private String steps;

        public String getCommand() {
            return this.command;
        }

        public String getDescription() {
            return this.description;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getSteps() {
            return this.steps;
        }
    }

    public static class Nodes {
        private String systemid;
        private String nodeid;
        private String name;
        private String state;
        private String updated;
        private String hostname;
        private String publicip;
        private String privateip;
        private String port;
        private String instanceid;
        private String dbusername;
        private String dbpassword;
        private String repusername;
        private String reppassword;
        private List<Commands> commands;
        private GsonSharedMonitorLatest monitorlatest;
        private String lastmonitored;
        private String command;
        private String taskid;

        public int getSystemId() {
            try {
                return Integer.parseInt(this.systemid);
            }
            catch (NumberFormatException nfex) {
                return -1;
            }
        }

        public int getNodeId() {
            try {
                return Integer.parseInt(this.nodeid);
            }
            catch (NumberFormatException nfex) {
                return -1;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getState() {
            return this.state;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getPublicIP() {
            return this.publicip;
        }

        public String getPrivateIP() {
            return this.privateip;
        }

        public String getPort() {
            return this.port;
        }

        public int getInstanceID() {
            if (this.instanceid.isEmpty()) {
                return 0;
            }
            try {
                return Integer.parseInt(this.instanceid);
            }
            catch (NumberFormatException nfex) {
                return -1;
            }
        }

        public String getDbUserName() {
            return this.dbusername;
        }

        public String getDbPassword() {
            return this.dbpassword;
        }

        public List<Commands> getCommands() {
            return this.commands;
        }

        public GsonSharedMonitorLatest getMonitorLatest() {
            return this.monitorlatest;
        }

        public String getLastMonitored() {
            return this.lastmonitored;
        }

        public String getCommand() {
            return this.command;
        }

        public String getTaskId() {
            return this.taskid;
        }

        public String getRepUserName() {
            return this.repusername;
        }

        public String getRepPassword() {
            return this.reppassword;
        }

        public String getLastUpdateTime() {
            return this.updated;
        }
    }
}

