/*
 * Decompiled with CFR 0.152.
 */
package com.skysql.java;

import com.skysql.java.GsonErrors;
import com.skysql.java.GsonSharedMonitorLatest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GsonSystem
extends GsonErrors {
    private Systems system;
    private List<Systems> systems;

    public GsonSystem(Systems system) {
        this.system = system;
    }

    private Systems getSystem() {
        return this.system;
    }

    public List<Systems> getSystems() {
        if (this.systems != null) {
            return this.systems;
        }
        if (this.getSystem() != null) {
            ArrayList<Systems> listSystems = new ArrayList<Systems>(1);
            listSystems.add(this.getSystem());
            return listSystems;
        }
        return null;
    }

    public Systems getSystem(int index) {
        try {
            return this.getSystems().get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<Integer> getSystemIdList() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (this.getSystem() != null) {
            result.add(this.getSystem().getSystemId());
        } else if (this.getSystems() != null) {
            Iterator<Systems> it = this.getSystems().iterator();
            while (it.hasNext()) {
                result.add(it.next().getSystemId());
            }
        } else {
            return null;
        }
        return result;
    }

    public static class Properties {
        private String MonitorInterval;
        private String IPMonitor;

        public Integer getMonitorInterval() {
            try {
                return Integer.parseInt(this.MonitorInterval);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getIPMonitor() {
            return this.IPMonitor;
        }
    }

    public static class Systems {
        private String systemid;
        private String systemtype;
        private String name;
        private String started;
        private String lastaccess;
        private String updated;
        private String state;
        private String dbusername;
        private String dbpassword;
        private String repusername;
        private String reppassword;
        private List<String> nodes;
        private String lastbackup;
        private Properties properties;
        private GsonSharedMonitorLatest monitorlatest;
        private String lastmonitored;

        public int getSystemId() {
            return Integer.parseInt(this.systemid);
        }

        public String getSystemtype() {
            return this.systemtype;
        }

        public String getName() {
            return this.name;
        }

        public String getStarted() {
            return this.started;
        }

        public String getLastaccess() {
            return this.lastaccess;
        }

        public String getState() {
            return this.state;
        }

        public List<String> getNodes() {
            return this.nodes;
        }

        public String getLastBackup() {
            return this.lastbackup;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public GsonSharedMonitorLatest getMonitorLatest() {
            return this.monitorlatest;
        }

        public String getDbUserName() {
            return this.dbusername;
        }

        public String getDbPassword() {
            return this.dbpassword;
        }

        public String getRepUserName() {
            return this.repusername;
        }

        public String getRepPassword() {
            return this.reppassword;
        }

        public String getLastUpdateTime() {
            return this.updated;
        }

        public String getLastMonitored() {
            return this.lastmonitored;
        }
    }
}

