/*
 * Decompiled with CFR 0.152.
 */
package com.skysql.java;

import java.util.Random;
import org.productivity.java.syslog4j.Syslog;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.impl.message.modifier.text.PrefixSyslogMessageModifier;

public class Logging {
    private SyslogIF m_syslog = Syslog.getInstance(this.m_protocol);
    private static volatile Logging INSTANCE = null;
    private static String m_host = "127.0.0.1";
    private String m_protocol = "unix_socket";
    private static int m_port = 514;
    private String m_prefix;
    private static String m_component = "";

    private static Logging getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Logging();
        }
        return INSTANCE;
    }

    private static SyslogIF getSyslog() {
        return Logging.getInstance().m_syslog;
    }

    public static Logging setHost(String host) {
        m_host = host;
        Logging.getSyslog().getConfig().setHost(m_host);
        return Logging.getInstance();
    }

    public static Logging setProtocol(String protocol) {
        if (!Syslog.exists(protocol)) {
            return Logging.getInstance();
        }
        Logging.getInstance().m_protocol = protocol;
        INSTANCE = null;
        INSTANCE = new Logging();
        Logging.setHost(m_host);
        return Logging.setPort(m_port);
    }

    public static Logging setPort(int port) {
        m_port = port;
        Logging.getSyslog().getConfig().setPort(m_port);
        return Logging.getInstance();
    }

    public static Logging setComponent(String component) {
        m_component = component;
        return Logging.getInstance();
    }

    private Logging() {
        this.m_syslog.getConfig().setFacility("user");
        this.m_prefix = "MariaDB-Manager-" + m_component + ": ";
        Random random = new Random();
        this.m_prefix = this.m_prefix + "[" + random.nextInt(999999) + "]";
        PrefixSyslogMessageModifier prefixModifier = new PrefixSyslogMessageModifier(this.m_prefix);
        this.m_syslog.getConfig().removeAllMessageModifiers();
        this.m_syslog.getConfig().addMessageModifier(prefixModifier);
    }

    public static void info(String message) {
        try {
            Logging.getSyslog().info(message);
        }
        catch (Exception e) {
            System.out.println("info log.");
        }
    }

    public static void error(String message) {
        try {
            Logging.getSyslog().error(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void warn(String message) {
        try {
            Logging.getSyslog().warn(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void debug(String message) {
        try {
            Logging.getSyslog().debug(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

